% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{ImportCDs}
\alias{ImportCDs}
\title{Import catchment descriptors from .CD3 files}
\usage{
ImportCDs(x, web = TRUE)
}
\arguments{
\item{x}{the CD3 file path}

\item{web}{logical argument with a default of TRUE. TRUE is to be used to import CDs from a FEH webserver downloaded CD3 file. FALSE is to be used to import CDs from a peak flows dataset CD3 file}
}
\value{
A data.frame with columns; Descriptor and Value.
}
\description{
Imports catchment descriptors from CD3 files either from an FEH webservice download or from the Peakflows dataset downloaded from the national river flow archive (NRFA) website
}
\details{
The CD3 files downloaded from the FEH webserver are formatted differently from the CD3 files of the peak flows dataset. For this reason it is necessary to specify web as TRUE or FALSE. TRUE indicates an FEH webserver derived CD3 and FALSE indicates a peak flows dataset CD3. File paths for importing data require forward slashes. On some operating systems, such as windows, the copy and pasted file paths will have backward slashes and would need to be changed accordingly.
}
\examples{
#Import catchment descriptors from a NRFA peakflows CD3 file and display in console
\donttest{CDs.4003 <- ImportCDs("C:/Data/NRFAPeakFlow_v9/Suitable for QMED/4003.CD3", web = FALSE)}
\donttest{CDs.4003}
#Import catchment descriptors from a FEH webserver CD3 file and display CDs in the console
\donttest{CDs.MySite <- ImportCDs("C:/Data/FEH_Catchment_384200_458200.CD3")}
}
\author{
Anthony Hammond
}
