% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{QMED}
\alias{QMED}
\title{QMED (median annual maximum flow) estimate from catchment descriptors}
\usage{
QMED(
  CDs = NULL,
  Don1 = NULL,
  Don2 = NULL,
  UrbAdj = FALSE,
  AREA,
  SAAR,
  FARL,
  BFIHOST,
  URBEXT2000 = NULL
)
}
\arguments{
\item{CDs}{catchment descriptors derived from either GetCDs or ImportCDs}

\item{Don1}{numeric site reference for the a signle donor (for donor candidates see DonAdj function)}

\item{Don2}{vector of two site references for two donors (for donor candidates see DonAdj function)}

\item{UrbAdj}{logical argument with a default of FALSE. True applies an urban adjustment}

\item{AREA}{catchment area in km2}

\item{SAAR}{standard average annual rainfall (mm)}

\item{FARL}{flood attenuation from reservoirs and lakes}

\item{BFIHOST}{baseflow index calculated from the catchment hydrology of soil type classification}

\item{URBEXT2000}{measure of catchment urbanisation}
}
\value{
An estimate of QMED from catchment descriptors
}
\description{
Estimated median annual maximum flow from catchment descriptors and donor sites
}
\details{
QMED is estimated from catchment descriptors: QMED = 8.3062*AREA^0.8510 0.1536^(1000/SAAR) FARL^3.4451 0.0460^(BFIHOST^2) as derived in Science Report: SC050050 - Improving the FEH statistical procedures for flood frequency estimation. The single donor method is from the same paper. The method for two donors is outlined in 'Kjeldsen, T. (2019). Adjustment of QMED in ungauged catchments using two donor sites. Circulation - The Newsletter of the British Hydrological Society, 4'. When UrbAdj = TRUE, urban adjustment is applied to the QMED estimate according to the method outlined in the guidance by Wallingford HydroSolutions: 'WINFAP 4 Urban Adjustment Procedures'. For flexibility there is the option to input the relevant catchment descriptors directly rather than a CDs object.
}
\examples{
#Get some catchment descriptors and calculate QMED as if it was ungauged, with
#no donors, one donor, and two donors
CDs.55004 <- GetCDs(55004)
QMED(CDs.55004)
QMED(CDs.55004, Don1 = 55012)
QMED(CDs.55004, Don2 = c(55012, 60007))
#Get CDs for urban gauge and calculate QMED with urban adjustment
CDs.27083 <- GetCDs(27083)
QMED(CDs.27083, UrbAdj = TRUE)
}
\author{
Anthony Hammond
}
