% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{GenLogPars}
\alias{GenLogPars}
\title{Generalised logistic distribution parameter estimates}
\usage{
GenLogPars(x = NULL, mle = FALSE, L1, LCV, LSKEW)
}
\arguments{
\item{x}{numeric vector. The sample}

\item{mle}{logical argument with a default of FALSE. If FALSE the parameters are estimated with Lmoments, if TRUE the parameters are estimated by maximum likelihood estimation.}

\item{L1}{first Lmoment}

\item{LCV}{linear coefficient of variation}

\item{LSKEW}{linear skewness}
}
\value{
Parameter estimates (location, scale, shape)
}
\description{
Estimated parameters from a sample (with Lmoments or maximum likelihood estimation) or from L1 (first L-moment), Lcv (linear coefficient of variation), and LSkew (linear skewness)
}
\details{
The L-moment estimated parameters are by the method detailed in 'Hosking J. Wallis J. 1997 Regional Frequency Analysis: An Approach Based on L-moments. Cambridge University Press, New York'
}
\examples{
#Get an annual maximum sample and estimate the parameters using Lmoments
AM.27090 <- GetAM(27090)
GenLogPars(AM.27090$Flow)
#Estimate parameters using MLE
GenLogPars(AM.27090$Flow, mle = TRUE)
#calculate Lmoments and estimate the parmeters with L1, Lcv and Lskew
Lmoms(AM.27090$Flow)
#store linear moments in an object
LPars <- as.numeric(Lmoms(AM.27090$Flow))[c(1,5,6)]
GenLogPars(L1 = LPars[1], LCV = LPars[2], LSKEW = LPars[3])
}
\author{
Anthony Hammond
}
