% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRINT.R
\name{print.UPG.Binomial}
\alias{print.UPG.Binomial}
\title{Print information for UPG.Binomial objects}
\usage{
\method{print}{UPG.Binomial}(x, ...)
}
\arguments{
\item{x}{an object of class \code{UPG.Binomial}.}

\item{...}{other print parameters.}
}
\description{
\code{print} provides some basic information about an \code{UPG.Binomial} object.
}
\examples{
\donttest{
# estimate a binomial logit model using example data
library(UPG)
data(titanic)
y  = titanic[,1]
Ni = titanic[,2]
X  = titanic[,-c(1,2)]
results.binomial = UPG(y = y, X = X, Ni = Ni, type = "binomial")
print(results.binomial)
}
}
\seealso{
\code{\link{summary.UPG.Binomial}} to summarize the estimates of a discrete choice model from an \code{UPG.Binomial} object and create tables.
\code{\link{predict.UPG.Binomial}} to predict probabilities from a discrete choice model from an \code{UPG.Binomial} object.
\code{\link{plot.UPG.Binomial}} to plot the results of a discrete choice model from an \code{UPG.Binomial} object.
}
\author{
Gregor Zens
}
