% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_randomKde2d.R
\name{analyse_randomKde2d}
\alias{analyse_randomKde2d}
\title{Perform analysis of random 2d distributions}
\usage{
analyse_randomKde2d(nfields=100, nstars, maxX, maxY, nKde=50, 
showStats=FALSE, returnStats=TRUE)
}
\arguments{
\item{nfields}{an integer with the number of individual field realisations}

\item{nstars}{an integer with the number of stars to consider}

\item{maxX}{the length of the field in X}

\item{maxY}{the length of the field in Y}

\item{nKde}{the number of samplings of the kernel in each direction}

\item{showStats}{a boolean indicating if the user wants to see statistics}

\item{returnStats}{a boolean indicating if the user wants statistics to be returned}
}
\value{
A data frame with the \code{mean} and \code{sd} fields containing the results 
of the random field analysis.
}
\description{
\code{analyse_randomKde2d} will compute statistics from uniformly randomly
created 2D fields based on Kernel Density Estimations (calling the code \code{\link{create_randomKde2d}}).
}
\examples{
# Runs the analysis on random fields
toyRes <- analyse_randomKde2d(100, 200, 100, 100, showStats=TRUE)

# Clean the environment
rm(toyRes)
 
}
\author{
Alberto Krone-Martins, Andre Moitinho
}
\keyword{utilities}
