% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcSSE_Acoef.R
\name{calcSSE_Acoef}
\alias{calcSSE_Acoef}
\title{Sum of squared errors (SSE) between coefficients of two VARs}
\usage{
calcSSE_Acoef(Acoef1, Acoef2)
}
\arguments{
\item{Acoef1, Acoef2}{Each one is a list object with K-by-K coefficient
matrices of lagged endogenous variables. See help(Acoef_sh), or,
help(Acoef).}
}
\value{
SSE value.
}
\description{
Compute sum of squared errors of coefficients of lagged endogenous
variables (Acoef) of two VAR models.
}
\details{
Consider VAR(p) model:
\deqn{y_t = A_1 y_{t-1} + ... + A_p y_{t-p} + C d_t + e_t.}
The SSE of two VAR(p) models is expressed as
\deqn{sum_{k=1}^p sum_{i=1}^K sum_{j=1}^K ( (A_k)_{ij} - (A_k')_{ij} )^2.}
}
\examples{
data(Canada, package = "vars")
y <- diff(Canada)
estim1 <- VARshrink(y, p = 2, type = "const", method = "fbayes")
Acoef1 <- Acoef_sh(estim1)
estim2 <- VARshrink(y, p = 2, type = "const", method = "ridge")
Acoef2 <- Acoef_sh(estim2)
calcSSE_Acoef(Acoef1, Acoef2)
}
