% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/vca.R
\name{Csweep}
\alias{Csweep}
\title{Calling C-implementation of the SWEEP-Operator}
\usage{
Csweep(M, asgn, thresh = 1e-08, tol = 1e-12, Ncpu = 1)
}
\arguments{
\item{M}{(matrix) matrix, representing the augmented matrix \eqn{X'X}}

\item{asgn}{(integer) vector, identifying columns in \eqn{M} corresponding variables,
respectively, to their coefficients}

\item{thresh}{(numeric) value used to check whether the influence of the a coefficient
to reducing the error sum of squares is small enough to coclude that the
corresponding column in \eqn{X'X} is a linear combination of preceding
columns}

\item{tol}{(numeric) value used to check numerical equivalence to zero}

\item{Ncpu}{(integer) number of cores to be used for parallel processing
                 (not yet used)}
}
\value{
(list) with two elements:\cr
			\item{SSQ}{(numeric) vector of ANOVA sum of squares}
			\item{LC}{(integer) vector indicating linear dependence of each column}
}
\description{
Function calls a fast C-implementation of the SWEEP operator using the
transpose of the original augmented matrix \eqn{X'X} (see \code{\link{getSSQsweep}}).
Transposing prior to applying the SWEEP-operator speeds up things since the
complete matrix is stored in memory in consecutive manner.
}
\details{
This is an utility-function not intended to be called directly.
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}

