% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vca.R
\name{getAmatrix}
\alias{getAmatrix}
\title{Determine A-Matrix.}
\usage{
getAmatrix(X1, X2)
}
\arguments{
\item{X1}{(matrix) lower order model matrix (comprising all factors entering model before 'X2'-factor)}

\item{X2}{(matrix) higher order model matrix (entering model after 'X1' factors)}
}
\value{
(matrix) for obtaining quadratic forms in \eqn{y} expression ANOVA sum of squares
}
\description{
Function \code{getAmatrix} finds A-matrices used to express ANOVA sum of squares as quadratic forms in \eqn{y}{y}.
}
\details{
Compute A-Matrix for expressing ANOVA Type-1 sequential sum of squares \eqn{m_{SS}}{SS} as quadratic form in \eqn{y} (column vector of observations),
\eqn{y^{T}Ay = m_{SS}}{y' * A * y = SS}.
In random models, when the intercept is the only fixed effect, the design matrix of fixed effects is equal to a column vector
where each element is equal to one (1). In this setting, it holds \eqn{1^{T}A1 = 0}{1' * A * 1 = 0}, i.e. all elements of A summing to zero.

This function is not intended to be used directly.
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}

