% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{conditionHandler}
\alias{conditionHandler}
\title{Condition-Handling Without Losing Information.}
\usage{
conditionHandler(expr, file = NULL)
}
\arguments{
\item{expr}{(expression) for which exception handling should be provided}

\item{file}{(character) string specifying a file to which all captured output
shall be written}
}
\value{
(list) with element "result", "status" (0 = no warnings, no errors), 1 = warnings
			were caught, 2 = errors were caught no result generated, "warnings", "errors", 
			"messages"
}
\description{
Function is intented to wrap expressions provided and catching
all potentially useful information generated by the wrapped expression, i.e.
errors, warnings, and messages.
}
\examples{
conditionHandler(warning("This is a warning!"))
f <- function(expr){warning("This a warning!"); eval(expr)}
conditionHandler(f(1/2))
conditionHandler(stop("This is an error!"))
conditionHandler(1/"a")
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
