\name{yulesimonMeanlink}
\alias{yulesimonMeanlink}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{

  Link functions for the mean of 1--parameter 
  discrete distributions: The Yule--Simon Distribution.

}
\description{
 
  Computes the \code{yulesimonMeanlink} transformation, its inverse
  and the first two derivatives.

}
\usage{
%
 yulesimonMeanlink(theta, bvalue = NULL, inverse = FALSE, 
                   deriv = 0, short = TRUE, tag = FALSE)
%
}
\arguments{
  \item{theta}{
   Numeric or character. This is \eqn{\theta}{theta} by default,
   or \eqn{\eta}{eta} depending upon other arguments. 
   See \code{\link[VGAM:Links]{Links}}.
  
  }
  \item{bvalue, inverse, deriv, short, tag}{
  Details at \code{\link[VGAM:Links]{Links}}
  
  }
}

\details{

  Assume \eqn{Y \sim {\rm{Yule-Simon}}(\rho) }{Y ~ Yule-Simon(rho)}, 
  where \eqn{\rho}{rho} is a shape parameter as in
  \code{\link[VGAM:yulesimon]{yulesimon}}.
  Then, the mean of \eqn{Y} 
  is given by
  %
  \deqn{\mu = \frac{\rho}{\rho - 1} = (1 - \rho^{-1})^{-1},
  }{\mu = rho / (rho - 1) = (1 - rho^(-1))^(-1),}
  %
  provided \eqn{ \rho > 1 }{rho > 1}.
  
  This link function may be conceived as a natural link function 
  for the mean of the Yule--Simon distribution which comes up by 
  taking the logarithm on both sides of this equation. More precisely, 
  the \code{yulesimonMeanlink} tranformation for \eqn{\rho > 1}{rho > 1}
  is given by
  %
  \deqn{ {\tt{yulesimonMeanlink}}(\rho) = - \log (1 - \rho^{-1}).}{
           yulesimonMeanlink(rho) = - log (1 - rho^(-1)).
  }
  %
  While this link function can be used to model any parameter lying in 
  \eqn{(1, \infty)}, it is particularly useful for event-rate data where
  the mean, \eqn{\mu}, can be written in terms of some rate of events,
  say \eqn{\lambda}{\lambda}, and the timeframe observed \eqn{t}. 
  Specifically,
  %
  \deqn{\mu = \lambda t.}
  %
  Assuming that additional covariates might be available to linearly 
  model \eqn{\lambda} (or \eqn{\log \lambda}{log(\lambda)}), 
  this model can be treated as a VGLM with one parameter where
  the time \eqn{t} (as \eqn{\log t}{log(t)}) can be easily incorporated 
  in the analysis as an offset.
  
  Under this link function the domain set for \eqn{\rho}{rho} 
  is \eqn{(1, \infty)}. Hence, values of \eqn{\rho}{rho} too 
  close to \eqn{1} from the right, or out of range will result 
  in \code{Inf}, \code{-Inf}, \code{NA} or \code{NaN}. 
  Use argument \code{bvalue} to adequately replace them before 
  computing the link function.
  %Specially, when \code{inverse = TRUE} and \code{deriv = 0},
  %\eqn{\rho}{rho} (i.e. \code{theta}) becomes \eqn{\eta}, and then 
  %the domain set is extended to \eqn{(0, \infty)}.
  
  Unlike \code{\link[VGAMextra:logffMeanlink]{logffMeanlink}} and
  \code{\link[VGAMextra:zetaffMeanlink]{zetaffMeanlink}}, the inverse of
  this link function can be written in close form.
  
  If \code{theta} is a character, arguments \code{inverse} and 
  \code{deriv} are disregarded.
  
}
\value{

  For \code{deriv = 0}, the \code{yulesimonMeanlink} transformation of
  \code{theta} when \code{inverse = FALSE}, and if 
  \code{inverse = TRUE} then 
  \code{exp(theta) / (exp(theta) - 1)}.
  
  
  For \code{deriv = 1}, \emph{d} \code{eta} / \emph{d} \code{theta} 
  as a function of \code{theta} if \code{inverse = FALSE}, else 
  the reciprocal \emph{d} \code{theta} / \emph{d} \code{eta}.


  For \code{deriv = 2} the second order derivatives 
  are correspondingly returned.

}
\note{

  If the underlying assumption \eqn{\rho > 1}{rho > 1} is not met,
  then this function returns \code{NaN}. 
  This is equivalent to claim that the mean is infinite or negative 
  and, consequently, its logarithm will not be real.
  
  The vertical line \code{theta = 1} is an asymptote for this link 
  function. As a result, it may return \code{Inf} for values of 
  \eqn{\rho}{rho} too close to \eqn{1} from the right.
 
}
\section{Warning}{

  Conforming with \code{\link[VGAM:yulesimon]{yulesimon}}, the domain 
  set for \eqn{rho} is \eqn{(0, \infty)}. However, in order for 
  \code{yulesimonMeanlink} to be a real number, \eqn{rho} must be greater 
  then 1.0. Then, when a VGLM is fitted via 
  \code{\link[VGAM:yulesimon]{yulesimon}} using this link function, 
  numerical instability will occur if the estimated or the true value of
  \eqn{rho} lies between 0 and 1, or if the initial values for \eqn{rho} 
  generated by
  \code{\link[VGAM:yulesimon]{yulesimon}} fail to meet
  \eqn{rho > 1}. Alternatively, try 
  \code{\link[VGAMextra:posPoiMeanlink]{posPoiMeanlink}} or
  \code{\link[VGAM:loglink]{loglink}} if this happens.
  
}
\author{

 V. Miranda and T. W. Yee

}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
 \code{\link[VGAM:yulesimon]{yulesimon}},
 \code{\link[VGAM:Links]{Links}}, 
 \code{\link[VGAMextra:posPoiMeanlink]{posPoiMeanlink}},
 \code{\link[VGAM:loglink]{loglink}}.
 
}
\examples{

## Example 1  ##
Shapes <- 1:10 
yulesimonMeanlink(theta = Shapes, deriv = 1)  ## d eta/d theta, as function of theta

yulesl.inv <-
        yulesimonMeanlink(theta = yulesimonMeanlink(theta = Shapes),  # the inverse
                               inverse = TRUE) - Shapes
                      
summary(yulesl.inv)     ## zero


## Example 2. Special values of theta (rho) ##
rhos <- c(-Inf, -2, -1, 0.0, 0.5, 1, 5, 10, 100, Inf, NaN, NA) 
rbind(rho = rhos, 
      yuleslink  = yulesimonMeanlink(theta = rhos),
      inv.yulesl =yulesimonMeanlink(theta = rhos, inverse = TRUE))


## Example 3 The yulesimonMeanlink transformation and the first two derivatives ##
%
\donttest{
rhos <- seq(1, 20, by = 0.01)[-1]
y.rhos <- yulesimonMeanlink(theta = rhos, deriv = 0)
der.1  <- yulesimonMeanlink(theta = rhos, deriv = 1)
der.2  <- yulesimonMeanlink(theta = rhos, deriv = 2)

plot(y.rhos ~ rhos, col = "black", 
     main = "log(mu), mu = E[Y], Y ~ Yule-Simon(rho).",
     ylim = c(-5, 10), xlim = c(-1, 5), lty = 1, type = "l", lwd = 3)
abline(v = 1.0, col = "orange", lty = 2, lwd = 3)
abline(v = 0, h = 0, col = "gray50", lty = "dashed")

lines(rhos, der.1, col = "blue", lty = 5)
lines(rhos, der.2, col = "chocolate", lty = 4)
legend(2, 7, legend = c("yulesimonMeanlink", "deriv = 1", "deriv = 2"),
       col = c("black", "blue", "chocolate"), lty = c(1, 5, 4))
 }
}