% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fasttrack.R
\name{fasttrack}
\alias{fasttrack}
\title{Fast-track processing}
\usage{
fasttrack(data = data, Subject = Subject, Item = Item,
  EventColumns = c("Subject", "TRIAL_INDEX"), NoIA = NoIA,
  Offset = Offset, Recording = Recording, WhenLandR = WhenLandR,
  BinSize = BinSize, SamplingRate = SamplingRate, ObsPerBin = ObsPerBin,
  ObsOverride = FALSE, Constant = 0.5, Output = Output)
}
\arguments{
\item{data}{A data frame object created from an Eyelink Sample Report.}

\item{Subject}{An obligatory string containing the column name corresponding 
to the subject identifier.}

\item{Item}{An optional string containing the column name corresponding to 
the item identifier; by default, NA.}

\item{EventColumns}{A vector specifying the columns which will be used for creating 
the Event variable; by default, Subject and TRIAL_INDEX.}

\item{NoIA}{A positive integer indicating the number of interest areas defined 
when creating the study.}

\item{Offset}{A positive integer indicating amount of time in milliseconds.}

\item{Recording}{A string indicating which eyes were used for recording gaze data.}

\item{WhenLandR}{A string indicating which eye ("Right" or "Left) to use 
if gaze data is available for both eyes (i.e., Recording = "LandR").}

\item{BinSize}{A positive integer indicating the size of the binning window 
(in milliseconds).}

\item{SamplingRate}{A positive integer indicating the sampling rate (in Hertz) 
used to record the gaze data.}

\item{ObsPerBin}{A positive integer indicating the desired number of 
observations to be used in the calculations.}

\item{ObsOverride}{A logical value controlling restrictions on the value
provided to ObsPerBin. Default value is FALSE.}

\item{Constant}{A positive number used for the empirical logit and weights
calculation; by default, 0.5 as in Barr (2008).}

\item{Output}{An obligatory string containing either "ELogit" or "Binomial".}
}
\value{
A data table containing formatting and calculations.
}
\description{
\code{fasttrack} is a meta-function for advanced users who are 
already familiar with the package functions.
It takes all necessary arguments for the component functions
to produce proportion looks. It also takes an argument specifying 
if empirical logits or binomial data should be output.  The
function returns a dataframe contained the result of the series 
of subroutines.
}
\examples{
\dontrun{
library(VWPre)
# Perform meta-function on data
df <- fasttrack(data = dat, Subject = "RECORDING_SESSION_LABEL", Item = "itemid", 
       EventColumns = c("Subject", "TRIAL_INDEX"), NoIA = 4, Offset = 100, 
			Recording = "LandR", WhenLandR = "Right", BinSize = 20, 
			SamplingRate = 1000, ObsPerBin = 20, Constant = 0.5, 
			Output = "ELogit")
}
}

