% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmvn.R
\name{pmvn}
\alias{pmvn}
\title{Compute multivariate normal (MVN) probabilities that have spatial covariance
matrices using Vecchia approximation}
\usage{
pmvn(
  lower,
  upper,
  mean,
  locs = NULL,
  covName = "matern15_isotropic",
  covParms = c(1, 0.1, 0),
  m = 30,
  sigma = NULL,
  reorder = 0,
  NLevel1 = 12,
  NLevel2 = 10000,
  verbose = FALSE,
  retlog = FALSE,
  ...
)
}
\arguments{
\item{lower}{lower bound vector for TMVN}

\item{upper}{upper bound vector for TMVN}

\item{mean}{MVN mean}

\item{locs}{location (feature) matrix n X d}

\item{covName}{covariance function name from the `GpGp` package}

\item{covParms}{parameters for `covName`}

\item{m}{Vecchia conditioning set size}

\item{sigma}{dense covariance matrix, not needed when `locs` is not null}

\item{reorder}{whether to reorder integration variables. `0` for no,
`1` for FIC-based univariate ordering, `2` for Vecchia-based univariate
ordering, and `3` for the reordering implemented in TruncatedNormal, 
which appeared faster than `2`}

\item{NLevel1}{first level Monte Carlo sample size}

\item{NLevel2}{second level Monte Carlo sample size}

\item{verbose}{verbose or not}

\item{retlog}{TRUE or FALSE for whether to return loglk or not}

\item{...}{could be
m_ord for conditioning set size for reordering}
}
\value{
estimated MVN probability and estimation error
}
\description{
Compute multivariate normal (MVN) probabilities that have spatial covariance
matrices using Vecchia approximation
}
