\name{BiCopMetaContour}      
\alias{BiCopMetaContour}        

\title{Contour Plot of Bivariate Meta Distribution
}

\description{
This function plots a bivariate contour plot corresponding to a bivariate meta distribution with different margins 
and specified bivariate copula and parameter values or creates corresponding empirical contour plots based on bivariate copula data.
}

\usage{
BiCopMetaContour(u1 = NULL, u2 = NULL, bw = 1, size = 100,
                 levels = c(0.01, 0.05, 0.1, 0.15, 0.2), 
                 family = "emp", par = 0, par2 = 0, PLOT = TRUE,
                 margins = "norm", margins.par = 0, xylim = NA, ...)
}

\arguments{
  \item{u1, u2}{Data vectors of equal length with values in [0,1] (default: \code{u1} and \code{u2 = NULL}).}
  \item{bw}{Bandwidth (smoothing factor; default: \code{bw = 1}).}
  \item{size}{Number of grid points; default: \code{size = 100}.}
  \item{levels}{Vector of contour levels.
    For Gaussian, Student t or exponential margins the default value (\code{levels = c(0.01, 0.05, 0.1, 0.15, 0.2)}) typically is a good choice.
    For uniform margins we recommend\cr
    \code{levels = c(0.1, 0.3, 0.5, 0.7, 0.9, 1.1, 1.3, 1.5)}\cr
    and for Gamma margins\cr
    \code{levels = c(0.005, 0.01, 0.03, 0.05, 0.07, 0.09)}.}
  \item{family}{An integer defining the bivariate copula family or indicating an empirical contour plot: \cr
    \code{"emp"} = empirical contour plot (default; margins can be specified by \code{margins}) \cr
		\code{0} = independence copula \cr
	        \code{1} = Gaussian copula \cr
	        \code{2} = Student t copula (t-copula) \cr
	        \code{3} = Clayton copula \cr
	        \code{4} = Gumbel copula \cr
	        \code{5} = Frank copula \cr
	        \code{6} = Joe copula \cr 
		\code{7} = BB1 copula \cr
		\code{8} = BB6 copula \cr
		\code{9} = BB7 copula \cr
		\code{10} = BB8 copula \cr
		\code{13} = rotated Clayton copula (180 degrees; ``survival Clayton'') \cr
		\code{14} = rotated Gumbel copula (180 degrees; ``survival Gumbel'') \cr
		\code{16} = rotated Joe copula (180 degrees; ``survival Joe'') \cr 
		\code{17} = rotated BB1 copula (180 degrees; ``survival BB1'')\cr
		\code{18} = rotated BB6 copula (180 degrees; ``survival BB6'')\cr
		\code{19} = rotated BB7 copula (180 degrees; ``survival BB7'')\cr
		\code{20} = rotated BB8 copula (180 degrees; ``survival BB8'')\cr
		\code{23} = rotated Clayton copula (90 degrees) \cr
		\code{24} = rotated Gumbel copula (90 degrees) \cr
		\code{26} = rotated Joe copula (90 degrees) \cr
		\code{27} = rotated BB1 copula (90 degrees) \cr
		\code{28} = rotated BB6 copula (90 degrees) \cr
		\code{29} = rotated BB7 copula (90 degrees) \cr
		\code{30} = rotated BB8 copula (90 degrees) \cr
		\code{33} = rotated Clayton copula (270 degrees) \cr
		\code{34} = rotated Gumbel copula (270 degrees) \cr
		\code{36} = rotated Joe copula (270 degrees) \cr
		\code{37} = rotated BB1 copula (270 degrees) \cr
		\code{38} = rotated BB6 copula (270 degrees) \cr
		\code{39} = rotated BB7 copula (270 degrees) \cr
		\code{40} = rotated BB8 copula (270 degrees) \cr
    \code{104} = Tawn type 1 copula \cr
    \code{114} = rotated Tawn type 1 copula (180 degrees) \cr
    \code{124} = rotated Tawn type 1 copula (90 degrees)  \cr
    \code{134} = rotated Tawn type 1 copula (270 degrees) \cr
    \code{204} = Tawn type 2 copula  \cr
    \code{214} = rotated Tawn type 2 copula (180 degrees) \cr
    \code{224} = rotated Tawn type 2 copula (90 degrees)  \cr
    \code{234} = rotated Tawn type 2 copula (270 degrees) \cr
		}
  \item{par}{Copula parameter; if empirical contour plot, \code{par = NULL} or \code{0} (default).}
  \item{par2}{Second copula parameter for t-, BB1, BB6, BB7, BB8, Tawn type 1 and type 2 copulas (default: \code{par2 = 0}).}
  \item{PLOT}{Logical; whether the results are plotted.
    If \code{PLOT = FALSE}, the values \code{x}, \code{y} and \code{z} are returned (see below; default: \code{PLOT = TRUE}).}
  \item{margins}{Character; margins for the bivariate copula contour plot. Possible margins are:\cr
    \code{"norm"} = standard normal margins (default)\cr
    \code{"t"} = Student t margins with degrees of freedom as specified by \code{margins.par}\cr
    \code{"gamma"} = Gamma margins with shape and scale as specified by \code{margins.par}\cr
    \code{"exp"} = Exponential margins with rate as specified by \code{margins.par}\cr
    \code{"unif"} = uniform margins}
  \item{margins.par}{Parameter(s) of the distribution of the margins if necessary (default: \code{margins.par = 0}), i.e., 
  	\itemize{
    \item a positive real number for the degrees of freedom of Student t margins (see \code{\link{dt}}),
  	\item a 2-dimensional vector of positive real numbers for the shape and scale parameters of Gamma margins (see \code{\link{dgamma}}),
  	\item a positive real number for the rate parameter of exponential margins (see \code{\link{dexp}}). 
  	}}
  \item{xylim}{A 2-dimensional vector of the x- and y-limits.
    By default (\code{xylim = NA}) standard limits for the selected margins are used.} 
  \item{...}{Additional plot arguments.}
}

\value{
  \item{x}{A vector of length \code{size} with the x-values of the kernel density estimator with Gaussian kernel 
  if the empirical contour plot is chosen and a sequence of values in \code{xylim} if the theoretical contour plot is chosen.}
  \item{y}{A vector of length \code{size} with the y-values of the kernel density estimator with Gaussian kernel
  if the empirical contour plot is chosen and a sequence of values in \code{xylim} if the theoretical contour plot is chosen.}
  \item{z}{A matrix of dimension \code{size} with the values of the density of the meta distribution
    with chosen margins (see \code{margins} and \code{margins.par}) evaluated at the grid points given by \code{x} and \code{y}.}
}

\note{
The combination \code{family = 0} (independence copula) and \code{margins = "unif"} (uniform margins) is not possible because all \code{z}-values are equal. 
}

\author{Ulf Schepsmeier, Alexander Bauer}

\seealso{\code{\link{BiCopChiPlot}}, \code{\link{BiCopKPlot}}, \code{\link{BiCopLambda}}}

\examples{
## Example 1: contour plot of meta Gaussian copula distribution
## with Gaussian margins
tau <- 0.5
fam <- 1
theta <- BiCopTau2Par(fam, tau)	
BiCopMetaContour(u1 = NULL, u2 = NULL, bw = 1, size = 100,
                 levels = c(0.01, 0.05, 0.1, 0.15, 0.2),
                 family = fam, par = theta, main = "tau = 0.5")


## Example 2: empirical contour plot with standard normal margins
dat <- BiCopSim(N = 1000, fam, theta)
BiCopMetaContour(dat[,1], dat[,2], bw = 2, size = 100,
                 levels = c(0.01, 0.05, 0.1, 0.15, 0.2),
                 par = 0, family = "emp", main = "N = 1000")

# empirical contour plot with exponential margins
BiCopMetaContour(dat[,1], dat[,2], bw = 2, size = 100,
                 levels = c(0.01, 0.05, 0.1, 0.15, 0.2),
                 par = 0, family = "emp", main = "n = 500",
                 margins = "exp", margins.par = 1)
}
