% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/walsNB.R
\name{walsNB}
\alias{walsNB}
\alias{walsNB.formula}
\alias{walsNB.matrix}
\alias{walsNBmatrix}
\alias{walsNB.default}
\title{Weighted-Average Least Squares for Negative Binomial Regression}
\usage{
walsNB(x, ...)

\method{walsNB}{formula}(
  formula,
  data,
  subset = NULL,
  na.action = NULL,
  weights = NULL,
  offset = NULL,
  link = "log",
  prior = weibull(),
  controlInitNB = controlNB(),
  model = TRUE,
  keepY = TRUE,
  keepX = FALSE,
  iterate = FALSE,
  tol = 1e-06,
  maxIt = 50,
  nIt = NULL,
  verbose = FALSE,
  ...
)

\method{walsNB}{matrix}(
  x,
  x2,
  y,
  link = "log",
  subset = NULL,
  na.action = NULL,
  weights = NULL,
  offset = NULL,
  prior = weibull(),
  controlInitNB = controlNB(),
  model = TRUE,
  keepY = TRUE,
  keepX = FALSE,
  iterate = FALSE,
  tol = 1e-06,
  maxIt = 50,
  nIt = NULL,
  verbose = FALSE,
  ...
)

\method{walsNB}{default}(x, ...)
}
\arguments{
\item{x}{Design matrix of focus regressors. Usually includes a constant
(column full of 1s) and can be generated using \code{\link[stats]{model.matrix}}.}

\item{...}{Arguments for workhorse \code{\link[WALS]{walsNBfit}}.}

\item{formula}{an object of class \code{"\link[Formula]{Formula}"}
(or one that can be coerced to that class, e.g. \code{"\link[stats]{formula}"}):
a symbolic description of the model to be fitted.
The details of model specification are given under ‘Details’.}

\item{data}{an optional data frame, list or environment
(or object coercible by \code{\link[base]{as.data.frame}} to a data frame)
containing the variables in the model. If not found in \code{data}, the variables
are taken from \code{environment(formula)}, typically the environment which
the function is called from.}

\item{subset}{an optional vector specifying a subset of observations to be
used in the fitting process.}

\item{na.action}{\strong{not implemented yet.}}

\item{weights}{\strong{not implemented yet.}}

\item{offset}{\strong{not implemented yet.}}

\item{link}{specifies the link function, currently only \code{"log"} is supported.}

\item{prior}{Object of class \code{"\link[WALS]{familyPrior}"}. For example
\code{\link[WALS]{weibull}} or \code{\link[WALS]{laplace}}.}

\item{controlInitNB}{Controls estimation of starting values for one-step ML,
see \code{\link[WALS]{controlNB}}.}

\item{model}{if \code{TRUE} (default), then the model.frame is stored in
the return.}

\item{keepY}{if \code{TRUE} (default), then the response is stored in
the return.}

\item{keepX}{if \code{TRUE}, then the model matrices are stored in the return.
the return.}

\item{iterate}{if \code{TRUE} then the WALS algorithm is iterated using the previous
estimates as starting values.}

\item{tol}{Only used if \code{iterate = TRUE} and \code{nIt = NULL}. If the
Euclidean distance between the previous and current coefficient vector divided
by the square root of the length of the vector falls below \code{tol} and the
absolute difference between the previous and current dispersion parameter
falls below \code{tol}, then the algorithm stops.
See \code{\link[WALS]{walsNBfitIterate}} for more details.}

\item{maxIt}{Only used if \code{iterate = TRUE} and \code{nIt = NULL}. Aborts
iterative fitting when number of iterations exceed \code{maxIt}.}

\item{nIt}{Only used if \code{iterate = TRUE}. If this is specified, then
\code{tol} is ignored and the algorithm iterates \code{nIt} times. This option
should not be used unless the user has a specific reason to run the algorithm
\code{nIt} times, e.g. for replication purposes.}

\item{verbose}{If \code{verbose = TRUE}, then it prints the iteration process
of internal function \code{\link[WALS]{walsNBfitIterate}}
(only relevant if \code{iterate = TRUE}).}

\item{x2}{Design matrix of auxiliary regressors. Usually does not include
a constant column and can also be generated using \code{\link[stats]{model.matrix}}.}

\item{y}{Count response as vector.}
}
\value{
\code{walsNB.formula()} returns an object of class \code{"walsNB"}
which inherits from \code{"walsGLM"} and \code{"wals"}. This is a list that
contains all elements returned from \code{\link[WALS]{walsNBfitIterate}} and
additionally
\item{cl}{Call of the function.}
\item{formula}{\code{formula} used.}
\item{terms}{List containing the model terms of the focus and auxiliary
regressors separately, as well as for the full model.}
\item{levels}{List containing the levels of the focus and auxiliary
regressors separately, as well as for the full model.}
\item{contrasts}{List containing the contrasts of the design matrices of
focus and auxiliary regressors.}
\item{model}{If \code{model = TRUE}, contains the model frame.}

See returns of \code{\link[WALS]{walsNBfit}} and \code{\link[WALS]{walsNBfitIterate}}
for more details.

\code{walsNB.matrix()} returns an object of class \code{"walsNBmatrix"},
which inherits from \code{"walsNB"}, \code{"walsGLMmatrix"}, \code{"walsGLM"}
and \code{"wals"}. This is a list that contains all elements returned from
\code{\link[WALS]{walsNBfitIterate}} and additionally the call in \code{cl}.

\code{walsNB.default()} raises an error if \code{x} is not an object
of class \code{"matrix"} or a class that extends \code{"matrix"}. Otherwise
returns an object of class \code{"walsNBmatrix"}. See above for more details.
}
\description{
Performs model averaging for NB2 regression models using the Weighted-Average
Least Squares method of \insertCite{huynhwalsnb;textual}{WALS}.
}
\details{
Computes WALS estimates when focus regressors (X1) are present in all
submodels and model averaging takes place over the auxiliary regressors (X2).

Formulas should always contain two parts, i.e. they should be of the form
"\code{y ~ X11 + X12 | X21 + X22}", where the variables before "\code{|}" are
the focus regressors (includes a constant by default) and the ones after
"\code{|}" are the auxiliary regressors.

\strong{WARNING:} Interactions in formula do not work properly yet.
It is recommended to manually create the interactions beforehand and then
to insert them as 'linear terms' in the formula.

See \code{\link[WALS]{predict.walsGLM}} and \code{\link[WALS]{predict.wals}}
for some class methods that the fitted objects inherit from
\code{"\link[WALS]{walsGLM}"} and \code{"\link[WALS]{wals}"}, respectively.

\code{walsNB.default()} raises an error if \code{x} is not an object of class
\code{"matrix"} or a class that extends \code{"matrix"}. Otherwise
it calls \code{walsNB.matrix()}. It is a modified version of \code{glmboost.default}
from the \code{mboost} package version 2.9-8 (2023-09-06) \insertCite{mboost}{WALS}.
}
\examples{
## Example for walsNB.formula()
data("NMES1988", package = "AER")

fitWeibull <- walsNB(visits ~ health + chronic + age + gender | I((age^2)/10) +
                     married + region, data = NMES1988, prior = weibull())
summary(fitWeibull)

fitLaplace <- walsNB(visits ~ health + chronic + age + gender | I((age^2)/10) +
                     married + region, data = NMES1988, prior = laplace())
summary(fitLaplace)

## Example for walsNB.matrix()
data("NMES1988", package = "AER")
X <- model.matrix(visits ~ health + chronic + age + gender + married + region,
                  data = NMES1988)
X1 <- X[, c("(Intercept)", "healthpoor", "healthexcellent", "chronic",
        "age", "gendermale")]
X2 <- X[, c("marriedyes", "regionnortheast", "regionmidwest", "regionwest")]
y <- NMES1988$visits
fit <- walsNB(X1, X2, y, prior = weibull())
summary(fit)

}
\references{
\insertAllCited{}
}
