% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculator_f.R
\name{qcond_lnorm}
\alias{qcond_lnorm}
\title{Conditional quantile function for lognormal distribution}
\usage{
qcond_lnorm(rnd = 0.5, meanlog, sdlog, lower_bound = 0, s_obs)
}
\arguments{
\item{rnd}{Vector of quantiles}

\item{meanlog}{The meanlog parameter}

\item{sdlog}{The sdlog parameter}

\item{lower_bound}{The lower bound to be used (current time)}

\item{s_obs}{is the survival observed up to lower_bound time,
normally defined from time 0 as 1 - plnorm(q = lower_bound, meanlog, sdlog) but may be different if parametrization has changed previously}
}
\value{
Estimate(s) from the conditional lognormal distribution based on given parameters
}
\description{
Conditional quantile function for lognormal distribution
}
\examples{
qcond_lnorm(rnd = 0.5, meanlog = 1,sdlog = 1,lower_bound = 1, s_obs=0.8)
}
