% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_river_discharge_data.R
\name{get_river_discharge_data}
\alias{get_river_discharge_data}
\title{Get river discharge data}
\usage{
get_river_discharge_data(lon, lat, dates)
}
\arguments{
\item{lon}{A numeric vector giving the longitude of the sampling sites in Decimal Degrees.}

\item{lat}{A numeric vector giving the latitude of the sampling sites in Decimal Degrees.}

\item{dates}{A character or date vector of dates giving the date when each sample was
collected (format is YYYY-MM-DD)}
}
\value{
data.frame
}
\description{
This function takes information of where and when a set of environmental samples were
collected and retrieves daily river discharge data from the nearest river (\eqn{m^3/s}) for those locations and times. Data come from
the Open-Meteo Global Flood API (\url{https://open-meteo.com/en/docs/flood-api})
via the \href{https://CRAN.R-project.org/package=openmeteo}{\code{openmeteo}} R package.
}
\examples{
\donttest{

tmp <- get_river_discharge_data(lon = c(-54.9857, -52.9857),
                                lat = c(-10.9094, -25.8756),
                                dates = c("2020-06-01", "2020-10-31"))

head(tmp)

}
}
