% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annual_agg.R
\name{annual_agg}
\alias{annual_agg}
\alias{annual_agg.default}
\title{Create annual aggregations of WRTDS output}
\usage{
annual_agg(dat_in, ...)

\method{annual_agg}{default}(dat_in, mo_strt = 10, min_mo = 9,
  logspace = TRUE, ...)
}
\arguments{
\item{dat_in}{input tidal or tidalmean object}

\item{...}{arguments passed to or from other methods}

\item{mo_strt}{numeric indicating month to start aggregation years, defaults to October for USGS water year from October to September}

\item{min_mo}{numeric value from one to twelve indicating the minimum number of months with observations for averaging by years}

\item{logspace}{logical indicating if aggregated data are to be shown in log-space or not}
}
\value{
An aggregated data object for plotting, returns only model output and response variable.
}
\description{
Create annual aggregations of WRTDS output
}
\details{
WRTDS output is averaged by year for both predictions and flow-normalized predictions. Years are averaged only if one observation is contained in each of the minimum number of months specified by \code{min_mo} averaging, otherwise results are not returned for the given year.  Note that setting \code{min_mo} to values smaller than the default can produce inaccurate trends for years with very few results. 

The function is used internally within \code{\link{prdnrmplot}} and \code{\link{fitplot}}.
}
\examples{
## tidal object
annual_agg(tidfit)

## tidalmean object
annual_agg(tidfitmean)
}

