% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistributionPlot.R
\name{PlotDistCountNormal}
\alias{PlotDistCountNormal}
\title{Plot distribution details as a histogram plus matching normal}
\usage{
PlotDistCountNormal(frm, xvar, title, ..., binWidth = c(),
  hist_color = "black", normal_color = "blue", mean_color = "blue",
  sd_color = "blue")
}
\arguments{
\item{frm}{data frame to get values from}

\item{xvar}{name of the independent (input or model) column in frame}

\item{title}{title to place on plot}

\item{...}{no unarmed argument, added to force named binding of later arguments.}

\item{binWidth}{width of histogram bins}

\item{hist_color}{color of empirical histogram}

\item{normal_color}{color of matching theoretical normal}

\item{mean_color}{color of mean line}

\item{sd_color}{color of 1-standard deviation lines (can be NULL)}
}
\description{
Compares empirical data to a normal distribution with the same mean and standard deviation.
}
\details{
Plots the histograms of the empirical distribution and of the matching normal distribution.
Also plots the mean and plus/minus one standard deviation.

Bin width for the histogram is calculated automatically to yield approximately 50 bins across the
range of the data, unless the \code{binWidth} argument is explicitly passed in. \code{binWidth} is reported
in the subtitle of the plot.
}
\examples{

set.seed(52523)
d <- data.frame(wt=100*rnorm(100))
PlotDistCountNormal(d,'wt','example')

# no sd lines
PlotDistCountNormal(d, 'wt', 'example', sd_color=NULL)

}
