% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROC.R
\name{plotlyROC}
\alias{plotlyROC}
\title{Use \code{plotly} to produce a ROC plot.}
\usage{
plotlyROC(
  d,
  predCol,
  outcomeCol,
  outcomeTarget,
  title,
  ...,
  estimate_sig = FALSE
)
}
\arguments{
\item{d}{dataframe}

\item{predCol}{name of column with numeric predictions}

\item{outcomeCol}{name of column with truth}

\item{outcomeTarget}{value considered true}

\item{title}{character title for plot}

\item{...}{no unnamed argument, added to force named binding of later arguments.}

\item{estimate_sig}{logical, if TRUE estimate and display significance of difference from AUC 0.5.}
}
\value{
plotly plot
}
\description{
Use \code{plotly} to produce a ROC plot.
}
\examples{

if(requireNamespace("plotly", quietly = TRUE)) {
   set.seed(34903490)
   x = rnorm(50)
   y = 0.5*x^2 + 2*x + rnorm(length(x))
   frm = data.frame(x=x,yC=y>=as.numeric(quantile(y,probs=0.8)))
   plotlyROC(frm, 'x', 'yC', TRUE, 'example plot', estimate_sig = TRUE)
}


}
\seealso{
\code{\link{ROCPlot}}
}
