% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScatterBoxPlot.R
\name{ScatterBoxPlot}
\alias{ScatterBoxPlot}
\title{Plot a scatter box plot.}
\usage{
ScatterBoxPlot(
  frm,
  xvar,
  yvar,
  title,
  ...,
  pt_alpha = 0.3,
  pt_color = "black",
  box_color = "black",
  box_fill = "lightgray"
)
}
\arguments{
\item{frm}{data frame to get values from}

\item{xvar}{name of the independent column in frame; assumed discrete}

\item{yvar}{name of the continuous column in frame}

\item{title}{plot title}

\item{...}{(doesn't take additional arguments, used to force later arguments by name)}

\item{pt_alpha}{transparency of points in scatter plot}

\item{pt_color}{point color}

\item{box_color}{boxplot line color}

\item{box_fill}{boxplot fill color (can be NA for no fill)}
}
\description{
Plot a boxplot with the data points superimposed.
}
\details{
\code{xvar} is a discrete variable and \code{yvar} is a continuous variable.
}
\examples{

classes = c("a", "b", "c")
means = c(2, 4, 3)
names(means) = classes
label = sample(classes, size=1000, replace=TRUE)
meas = means[label] + rnorm(1000)
frm2 = data.frame(label=label,
                  meas = meas)
WVPlots::ScatterBoxPlot(frm2, "label", "meas", pt_alpha=0.2, title="Example Scatter/Box plot")

}
\seealso{
\code{\link{ScatterBoxPlotH}}
}
