% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GetValues.R
\name{GetValues}
\alias{GetValues}
\title{GetValues}
\usage{
GetValues(server, siteCode, variableCode, startDate = NULL, endDate = NULL,
  daily = NULL)
}
\arguments{
\item{server}{The URL of the web service ending with .asmx,
for example: http://worldwater.byu.edu/interactive/rushvalley/services/index.php/cuahsi_1_1.asmx?WSDL}

\item{siteCode}{The site code. To get a list of available site codes, see GetSites() function
and use the FullSiteCode field.}

\item{variableCode}{The variable code. To get a list of possible variable codes, see GetVariables()
function and use the FullVariableCode field}

\item{startDate}{(optional) The start date in "yyyy-mm-dd" format}

\item{endDate}{(optional) The end date in "yyyy-mm-dd" format}

\item{daily}{(optional) If you set daily="max", daily="min" or daily="mean", then the
data values are aggreagted to daily time step.}
}
\description{
This function gets the time series data values from the WaterML web service
}
\examples{
#example 1: Get Values from a known site and variable from RushValley server
GetValues("http://worldwater.byu.edu/app/index.php/rushvalley/services/cuahsi_1_1.asmx?WSDL",
           site="Ru5BMMA", variable="SRS_Nr_NDVI", startDate="2014-11-01", endDate="2014-11-02",
           daily="max")
}
\keyword{waterml}

