% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoordBase.R, R/RcppExports.R
\name{coords}
\alias{coords}
\alias{as_coords}
\alias{as_coords.default}
\alias{latlon<-}
\alias{as_coords.waypoints}
\title{Geographic Coordinate Class}
\usage{
as_coords(object, ...)

\method{as_coords}{default}(object, ..., fmt = 1L)

latlon(cd) <- value

\method{as_coords}{waypoints}(object, which, ...)
}
\arguments{
\item{object}{a \code{numeric} vector of coordinate values, optionally named, or an object of
class \code{"waypoints"}.}

\item{\dots}{further arguments passed to or from other methods.}

\item{fmt}{\code{integer}, \code{1L}, \code{2L} or \code{3L}, specifying the required coordinate
format.}

\item{cd}{object of class \code{"coords"} created by function \code{\link{as_coords}()}.}

\item{value}{a \code{logical} vector of length \code{1} or \code{length(x)}.}

\item{which}{\code{logical}, indicating whether the \code{as_coords()} method for class
\code{"waypoints"} extracts the latitude component of argument \code{object} (if \code{TRUE}),
or the longitude (if \code{FALSE}).}
}
\value{
\code{as_cords()} returns an object of class \code{"coords"}, comprising a \code{numeric} vector
argument with additional attributes: –

\item{\code{"class"}}{the \code{character} string "coords".}

\item{\code{"fmt"}}{an \code{integer} representing the coordinate format.}

\item{\code{"valid"}}{a \code{logical} vector indicating whether individual coordinate values
  are valid geographic locations.}

The \code{as_cords()} method for class \code{"coords"} returns its \code{numeric} vector argument
\code{object} modified in place, whereas the method for class 'waypoints' returns a new
\code{numeric} vector.

\code{latlon()} returns its \code{"coords"} argument \code{cd} with a \code{logical} vector
attribute \code{"latlon"} added or updated to reflect argument \code{value}.
}
\description{
\code{as_coords()} creates an object of class \code{"coords"}, a robust representation of a
series of geographic or GPS coordinate values.

\code{latlon()<-} adds information to objects of class \code{"coords"} specifying whether
individual coordinate values represent latitude or longitude.
}
\details{
Individual values provided in a \code{numeric} vector argument \code{object} should have a
decimal point after the number of whole degrees in the case of \emph{decimal degrees}, after the
number of whole minutes in the case of \emph{degrees and minutes}, and after the number of whole
seconds in the case of \emph{degrees, minutes and seconds}.

The \code{fmt} argument should be \code{1L} to represent decimal degrees, \code{2L} for degrees
and minutes, and \code{3L} for degrees, minutes and seconds and is used to provide the
format of values in the \code{numeric} vector argument \code{object} to be converted to class
\code{"coords"}.

The values of a newly created \code{"coords"} object are checked to ensure they are valid
geographic locations as described under \code{\link{validate}()}.

Individual coordinate values in a \code{Coords} object may be specified as representing latitude
or longitude using \code{latlon()}. The \code{value} argument may either be a single value,
\code{TRUE} signifying that all values are latitude, \code{FALSE} signifying that all values are
longitude, or a \code{logical} vector of the same length as as the \code{Coords} object signifying
whether individual values are latitude or longitude.
}
\examples{
## Numeric vector representing degrees and minutes, with
## the decimal point after the number of whole minutes
dm <- c(5130.4659, 4932.7726, 4806.4339, 3853.3696, 0.0000, -3706.7044, -5306.2869, -2514.4093,
        -007.6754, 1823.9137, -12246.7203, -7702.1145, 0.0000, -1217.3178, 7331.0370, -5731.1536)

## Create an unnamed "coords" object in degrees and minutes (fmt = 2)
## (Latitude and longitude unspecified)
as_coords(dm, fmt = 2)

## Name the "coords" object
names(dm) <- rep(c("Nelson's Column", "Ostravice", "Tally Ho", "Washington Monument", "Null Island",
                   "Tristan da Cunha", "Mawson Peak", "Silvio Pettirossi International Airport"), 2)
dm

## Set all values to represent longitude
## ("latlon" attribute set to FALSE, length 1)
latlon(dm) <- FALSE
dm

## Set eight values each of latitude and longitude
## ("latlon" attribute set to TRUE, n=8, and FALSE, n=8)
latlon(dm) <- rep(c(TRUE, FALSE), each = 8)
dm

## Show as an ordinary R numeric vector
as.numeric(dm)

rm(dm)


}
\seealso{
\code{\link[base:attr]{attr}()}, \code{\link[base:attributes]{attributes}}, and
  \code{\link{validate}()}.

Other coordsandway: 
\code{\link{convert}()},
\code{\link{waypoints}}
}
\concept{coordsandway}
