% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{waldTest}
\alias{waldTest}
\title{Mixed Model Wald Tests}
\usage{
waldTest(fittedModel, type = c("beta", "Lambda"), coefs = NA, hypothesis = NA)
}
\arguments{
\item{fittedModel}{a  model of class \code{WeMixResults} that is the result of a call to \code{\link{mix}}}

\item{type}{a string, one of "beta" (to test the fixed effects) or "Lambda" (to test the variance-covariance parameters for the random effects)}

\item{coefs}{a vector containing the names of the coefficients to test. For \code{type="beta"} these must be
the variable names exactly as they appear in the fixed effects table of the summary. For \code{type="Lambda"}
these must be the names exactly as they appear in the theta element of the fitted model.}

\item{hypothesis}{the hypothesized values of beta or Lambda. If \code{NA} (the default) 0 will be used.}
}
\value{
Object of class \code{WeMixWaldTest}. 
This is a list with the following elements: 
\item{wald}{the value of the test statistic.}
\item{p}{the p-value for the test statistic. Based on the probabilty of the test statistic
under the chi-squared distribution.}
\item{df}{degrees of freedom used to calculate p-value.}
\item{H0}{The vector (for a test of beta) or matrix (for tests of Lambda) containing the 
null hypothesis for the test.}
\item{HA}{The vector (for a test of beta) or matrix (for tests of Lambda) containing the 
alternative hypothesis for the test (i.e. the values calculated by the fitted model being 
tested.)}
}
\description{
This function calculates the Wald test for either fixed effects or variance parameters.
}
\details{
By default this function tests against the null hypothesis that all coefficients are zero.
To identify which coefficients to test use the name exactly as it appears in 
the summary of the object.
}
\examples{
\dontrun{
library(lme4) #to use the example data 
sleepstudyU <- sleepstudy
sleepstudyU$weight1L1 <- 1
sleepstudyU$weight1L2 <- 1
wm0 <- mix(Reaction ~ Days + (1|Subject), data=sleepstudyU, 
            weights=c("weight1L1", "weight1L2"))
wm1 <- mix(Reaction ~ Days + (1 +Days|Subject), data=sleepstudyU, 
           weights=c("weight1L1", "weight1L2"))

waldTest(wm0, type="beta")  #test all betas 
#test only beta for days 
waldTest(wm0, type="beta", coefs="Days")  
#test only beta for intercept against hypothesis that it is 1
waldTest(wm0, type="beta", coefs="(Intercept)", hypothesis=c(1))  

waldTest(wm1,type="Lambda")  #test all values of Lambda
 #test only some Lambdas.The names are the same as names(wm1$theta)
waldTest(wm1,type="Lambda", coefs="Subject.(Intercept)") 
#specify  test values
waldTest(wm1,type="Lambda", coefs="Subject.(Intercept)", hypothesis=c(1))  
}
}
