% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xAggregate.r
\name{xAggregate}
\alias{xAggregate}
\title{Function to aggregate data respecting number of features}
\usage{
xAggregate(data, verbose = T)
}
\arguments{
\item{data}{a data frame. The aggregation is done across columns per
row. Each cell should contain positive values or NA; if infinite, it
will be replaced with the maximum finite value}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}
}
\value{
a data frame with an appended column called 'Aggregate'
}
\description{
\code{xAggregate} is supposed to aggregate data respecting number of
features. Per row, the aggregated is the sum of two items: the number
of features, and the sum of all but scaled into [0,0.9999999]
}
\note{
None
}
\examples{
\dontrun{
# Load the library
library(XGR)

RData.location <- "http://galahad.well.ox.ac.uk/bigdata_dev"
# HiC-gene pairs per cell types/states
g <- xRDataLoader(RData.customised='ig.PCHiC',
RData.location=RData.location)
df <- do.call(cbind, igraph::edge_attr(g))

# aggregate over cell types/states
data <- df
data[data<5] <- NA
res <- xAggregate(data)
}
}
\seealso{
\code{\link{xAggregate}}
}
