/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect;

import com.miraisolutions.xlconnect.CellStyle;
import com.miraisolutions.xlconnect.StyleAction;
import com.miraisolutions.xlconnect.Workbook;
import com.miraisolutions.xlconnect.data.Column;
import com.miraisolutions.xlconnect.data.DataFrame;
import com.miraisolutions.xlconnect.data.DataType;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Date;

public class App {
    public static void main(String[] args) throws Exception {
        String file = "/home/mstuder/test.xlsx";
        File f = new File(file);
        if (f.exists()) {
            f.delete();
        }
        Workbook wb = Workbook.getWorkbook(f, true);
        wb.setStyleAction(StyleAction.DATATYPE);
        CellStyle cs = wb.createCellStyle();
        cs.setDataFormat("d/m/yy");
        wb.setCellStyleForDataType(DataType.DateTime, cs);
        DataFrame df = new DataFrame();
        boolean[] missing = new boolean[]{false, false, false, false, false};
        Date date = new Date();
        df.addColumn("A", new Column(new double[]{1.0, 2.0, 3.0, 4.0, 5.0}, missing, DataType.Numeric));
        df.addColumn("B", new Column(new Date[]{date, date, date, date, date}, missing, DataType.DateTime));
        wb.createSheet("data");
        wb.writeWorksheet(df, "data", true);
        wb.save();
        App.printDataFrame(df);
    }

    public static void printDataFrame(DataFrame df) {
        for (int i = 0; i < df.columns(); ++i) {
            System.out.println(df.getColumnName(i) + ":");
            Object data = df.getColumn(i).getData();
            boolean[] missing = df.getColumn(i).getMissing();
            int len = missing.length;
            for (int j = 0; j < len; ++j) {
                if (missing[j]) {
                    System.out.print("[NA]");
                } else {
                    System.out.print(Array.get(data, j));
                }
                System.out.print(" ");
            }
            System.out.println();
        }
    }
}

