% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_and_reporting_functions.R
\name{generate_report}
\alias{generate_report}
\title{Generate a Comprehensive Analysis Report}
\usage{
generate_report(
  de_results,
  enrichment_results,
  grn_object,
  output_file = "analysis_report.html",
  template_path = NULL,
  params_list = list(),
  quiet = TRUE
)
}
\arguments{
\item{de_results}{Data frame or list with differential expression results.}

\item{enrichment_results}{List of enrichment results (e.g., BP, MF, KEGG, GSEA).}

\item{grn_object}{An igraph object of the gene regulatory network.}

\item{output_file}{Output report name (default: "analysis_report.html").}

\item{template_path}{Path to the R Markdown template. If NULL, uses the built-in template.}

\item{params_list}{Named list of extra parameters passed to the R Markdown report.}

\item{quiet}{Logical; if TRUE (default), rendering is quiet.}
}
\value{
Character string with the path to the rendered report.
}
\description{
Creates an integrated HTML report combining differential expression results,
enrichment analyses (GO, KEGG, GSEA), and gene regulatory network (GRN) data.
Uses a parameterized R Markdown template for rendering.
}
