% Generated by roxygen2 (4.0.1): do not edit by hand
\name{logme}
\alias{logme}
\title{Log the name and the content of an R object}
\usage{
logme(x = NULL, prefix = NULL, logger = NULL,
  envir = sys.frame(sys.parent(0)))
}
\arguments{
\item{x}{ANY, an R object.}

\item{prefix}{the prefix to log.}

\item{logger}{logging level, one of: NULL, 'INFO', 'DEBUG', 'WARNING', 'ERROR', 'CRITICAL'}

\item{envir}{the \code{environment} to use.}
}
\description{
Log the name and the content of an R object given levels of logger
}
\examples{
## log an object
x1 <- 1:6
logme(x1)

## log according to logger levels
bar <- function(x,envir=sys.frame(sys.parent(0))){
  for (.logger in get.loglevel()) {
    if (is.null(.logger)) .prefix <- 'NULL' else .prefix <- .logger
    logme(x,prefix=.prefix,logger=.logger,envir=envir)
  }
}
options(logger='DEBUG')
bar(1:6) # print logs of level NULL, INFO and DEBUG
options(logger='ERROR')
bar(1:6) # print logs of level NULL, INFO, DEBUG, WARNING and ERROR
}
\author{
Xiaobei Zhao
}
\seealso{
\code{\link{printme}}
}

