% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Thabit.R
\name{Thabit}
\alias{Thabit}
\alias{A055010}
\title{Thabit numbers}
\usage{
Thabit(n, Rmpfr = TRUE, PrecisionBits = 496)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{Rmpfr}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}

\item{PrecisionBits}{a positive integer for precision bits larger than 2.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A055010}{A055010}, the \emph{n}th \emph{Thabit} number is given as
\deqn{A_n = 3*2^{n-1}-1}
where the first 6 entries are  	0, 2, 5, 11, 23, 47 with \eqn{A_0 = 0.}
}
\examples{
## generate first 30 Thabit numbers
first30 = Thabit(30)

## print without trailing 0's.
print(first30, drop0trailing = TRUE)

}
