% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Telephone.R
\name{Telephone}
\alias{Telephone}
\alias{A000085}
\alias{Involution}
\title{Telephone numbers}
\usage{
Telephone(n, Rmpfr = TRUE, PrecisionBits = 496)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{Rmpfr}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}

\item{PrecisionBits}{a positive integer for precision bits larger than 2.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A000085}{A000085}, a \emph{Telephone} number - also known as \emph{Involution} number - is counting the number
of connection patterns in a telephone system with \code{n} subscribers, or in a more mathematical term, the number of self-inverse permutations on
\code{n} letters. First 6 Telephone numbers are  	1, 1, 2, 4, 10, 26,
}
\examples{
## generate first 20 Regular numbers
first20 = Regular(20)

## print without trailing 0's.
print(first20, drop0trailing = TRUE)

}
