% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_chladni.R
\name{canvas_chladni}
\alias{canvas_chladni}
\title{Draw Chladni Figures}
\usage{
canvas_chladni(colors, waves = 5, resolution = 500)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{waves}{a character specifying the number of randomly sampled waves, or an integer vector of waves to be summed.}

\item{resolution}{resolution of the artwork in pixels per row/column. Increasing the resolution increases the quality of the artwork but also increases the computation time exponentially.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function draws Chladni figures on a canvas.
}
\examples{
\donttest{
set.seed(1)

# Simple example
canvas_chladni(colors = colorPalette("lava"))

# Advanced example
canvas_chladni(colors = colorPalette("lava"), waves = c(1, 2, 3, 9))
}

}
\seealso{
\code{colorPalette}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
