% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_ant.R
\name{canvas_ant}
\alias{canvas_ant}
\title{Draw Langton's Ant}
\usage{
canvas_ant(colors, background = "#fafafa", iterations = 1000000,
           resolution = 500)
}
\arguments{
\item{colors}{a character (vector) specifying the color(s) used for the artwork.}

\item{background}{a character specifying the color used for the background.}

\item{iterations}{a positive integer specifying the number of iterations of the algorithm.}

\item{resolution}{resolution of the artwork in pixels per row/column. Increasing the resolution increases the quality of the artwork but also increases the computation time exponentially.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function draws Langton's Ant on a canvas. Langton's ant is a two-dimensional universal Turing machine with a very simple set of rules. These simple rules can lead to complex emergent behavior.
}
\details{
The algorithm for Langton's Ant involves repeating the following rules: 1) on a non-colored block: turn 90 degrees clockwise, un-color the block, move forward one block; 2)
         On a colored block: turn 90 degrees counter-clockwise, color the block, move forward one block; 3) If a certain number of iterations has passed, choose a different color which corresponds to a different combination of these rules.
}
\examples{
\donttest{
set.seed(1)

# Simple example
canvas_ant(colors = colorPalette("house"))
}

}
\references{
\url{https://en.wikipedia.org/wiki/Langtons_ant}
}
\seealso{
\code{colorPalette}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
