% Generated by roxygen2 (4.0.2): do not edit by hand
\name{stationary.test}
\alias{stationary.test}
\title{Stationary Test for Univariate Time Series}
\usage{
stationary.test(x, method = c("adf", "pp", "kpss"), nlag = NULL,
  type = c("Z_rho", "Z_tau"), lag.short = TRUE, output = TRUE)
}
\arguments{
\item{x}{a numeric vector or univariate time series.}

\item{method}{a character indicating which test to use. The default is
\code{"adf"} by Augmented Dickey-Fuller test.}

\item{nlag}{the lag order to calculate the test statistic, only valid for
\code{method = "adf"}. See \code{\link{adf.test}} for more details.}

\item{type}{the test type, only valid for \code{method = "pp"}.
See \code{\link{pp.test}} for more details.}

\item{lag.short}{a logical value, only valid for \code{method = "pp"} or \code{"kpss"}.
See \code{\link{pp.test}} and \code{\link{kpss.test}} for more details.}

\item{output}{a logical value indicating to print the results in R console.
The default is \code{TRUE}.}
}
\value{
The results are the same as one of the \code{\link{adf.test}}, \code{\link{pp.test}},
\code{\link{kpss.test}}, depending on which test are used.
}
\description{
Performs stationary test for a univariate time series.
}
\details{
This function combines the existing functions \code{\link{adf.test}},
\code{\link{pp.test}} and
\code{\link{kpss.test}} for testing the stationarity of a univariate time series \code{x}.
}
\note{
Missing values are removed.
}
\examples{
x <- arima.sim(list(order = c(1,0,0),ar = 0.2),n = 100)
stationary.test(x)  # same as adf.test(x)
stationary.test(x, method = "pp") # same as pp.test(x)
stationary.test(x, method = "kpss") # same as kpss.test(x)
}
\author{
Debin Qiu
}

