% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listTasks.R
\name{listTasks}
\alias{listTasks}
\title{List Tasks}
\usage{
listTasks(fromDate=NULL, toDate=NULL, excludeDeleted = FALSE, ...)
}
\arguments{
\item{fromDate}{Optional; format: yyyy-mm-ddThh:mm:ssZ}

\item{toDate}{Optional;   format: yyyy-mm-ddThh:mm:ssZ}

\item{excludeDeleted}{Optional; Boolean, Default=FALSE}

\item{\dots}{Additional arguments passed to \code{\link{abbyy_GET}}.}
}
\value{
A \code{data.frame} with the following columns: id (task id), registrationTime, statusChangeTime, status 
       (Submitted, Queued, InProgress, Completed, ProcessingFailed, Deleted, NotEnoughCredits), filesCount (No. of files), 
        credits, resultUrl (URL for the processed file)). If no tasks are finished, the last column (resultUrl) isn't returned.
}
\description{
List all the tasks in the application. You can specify a date range and whether or not you want to include deleted tasks. 
The function prints total number of tasks and no. of finished tasks by default.
}
\examples{
\dontrun{
listTasks()
listTasks(fromDate = "2015-11-10T00:00:00Z", toDate = "2016-11-10T00:00:00Z")
listTasks(fromDate = "2015-11-10T00:00:00Z")
}
}
\references{
\url{http://ocrsdk.com/documentation/apireference/listTasks/}
}
