% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abc_grid.R
\name{da_risk_estimator}
\alias{da_risk_estimator}
\title{Double Asymptotic Risk Estimator}
\usage{
da_risk_estimator(object, bias_correction = TRUE)
}
\arguments{
\item{object}{An object of class "abcrlda".}

\item{bias_correction}{Takes in a boolean value.
If \code{bias_correction} is TRUE, then asymptotic bias correction will be performed.
Otherwise, (if \code{bias_correction} is FALSE) asymptotic bias correction will not be performed and
the ABCRLDA is the classical RLDA.
The default is TRUE.}
}
\value{
Calculates risk based on estimated class error rates and misclassification costs
  \deqn{\Re = \varepsilon_0 * C_{10} + \varepsilon_1 * C_{01}}{R = e_0 * C_10 + e_1 * C_01)}
}
\description{
This function implements the generalized (double asymptotic) consistent estimator of risk.
}
\section{Reference}{

  A. Zollanvari, M. Abdirash, A. Dadlani and B. Abibullaev,
  "Asymptotically Bias-Corrected Regularized Linear Discriminant Analysis for Cost-Sensitive
  Binary Classification," in IEEE Signal Processing Letters, vol. 26, no. 9, pp. 1300-1304,
  Sept. 2019. doi: 10.1109/LSP.2019.2918485
  URL: \url{http://ieeexplore.ieee.org/stamp/stamp.jsp?tp=&arnumber=8720003&isnumber=8770167}
}

\examples{
data(iris)
train_data <- iris[which(iris[, ncol(iris)] == "virginica" |
                         iris[, ncol(iris)] == "versicolor"), 1:4]
train_label <- factor(iris[which(iris[, ncol(iris)] == "virginica" |
                                 iris[, ncol(iris)] == "versicolor"), 5])
model <- abcrlda(train_data, train_label, gamma = 0.5, cost = 0.75)
da_risk_estimator(model)
}
\seealso{
Other functions in the package: 
\code{\link{abcrlda}()},
\code{\link{cross_validation}()},
\code{\link{grid_search}()},
\code{\link{predict.abcrlda}()},
\code{\link{risk_calculate}()}
}
\concept{functions in the package}
