% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_case_mean_coverage.R
\name{get_case_mean_coverage}
\alias{get_case_mean_coverage}
\title{Compute the mean coverage of a CASE sample}
\usage{
get_case_mean_coverage(tabindex, pacbamfolder_bychrom)
}
\arguments{
\item{tabindex}{The data.frame output by the \code{callsnvs} function.}

\item{pacbamfolder_bychrom}{The folder popluted by outputs by the \code{split_pacbam_bychrom} function.}
}
\value{
The \code{sample.info.file} with an additional column reporting the mean coverage for each case (only for those with a matched-CONTROL)
}
\description{
Compute the mean coverage of a CASE sample
}
\examples{
sample.info.file <- system.file("extdata", "test_sif_toy.tsv", package = "abemus")
outdir <- tempdir()
targetbed <- system.file("extdata", "regions_toy.bed", package = "abemus")
pacbamfolder_bychrom <- system.file("extdata", "pacbam_data_bychrom", package = "abemus")
pbem_dir <- system.file("extdata", "BaseErrorModel", package = "abemus")
controls_dir <- system.file("extdata", "Controls", package = "abemus")
m<-callsnvs(sample.info.file,outdir,targetbed,pbem_dir,controls_dir,pacbamfolder_bychrom,replicas=1)
tabindex <- m$tabsnvs_index
tabindex <- get_case_mean_coverage(tabindex = tabindex,pacbamfolder_bychrom = pacbamfolder_bychrom)
}
