% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.abessrpca.R
\name{coef.abessrpca}
\alias{coef.abessrpca}
\title{Extract sparse component from a fitted "\code{abessrpca}" object.}
\usage{
\method{coef}{abessrpca}(object, support.size = NULL, sparse = TRUE, ...)
}
\arguments{
\item{object}{An "\code{abessrpca}" project.}

\item{support.size}{An integer vector specifies
the sparse matrix fitted at given \code{support.size} to be returned.
If \code{support.size = NULL}, then the sparse matrix with 
the least tuning value would be returned.
Default: \code{support.size = NULL}.}

\item{sparse}{A logical value, specifying whether the coefficients should be
presented as sparse matrix or not. Default: \code{sparse = TRUE}.}

\item{...}{Other arguments.}
}
\value{
A list with \code{length(support.size)} number of dgCMatrix,
each of which is the estimation the sparse component.
}
\description{
This function provides estimated
coefficients from a fitted "\code{abessrpca}" object.
}
