% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ADMM_EN2.R
\name{ADMM_EN2}
\alias{ADMM_EN2}
\title{ADMM on l1 regularized quadratic program}
\usage{
ADMM_EN2(R, d, x0, lam, mu, maxits, tol, quiet)
}
\arguments{
\item{R}{Upper triangular matrix in Chol decomp \eqn{\mu I + A = R^T R}{mu*I + A = R'*R}.}

\item{d}{nx1 dimensional column vector.}

\item{lam}{Regularization parameter for l1 penalty, must be greater than zero.}

\item{mu}{Augmented Lagrangian penalty parameter, must be greater than zero.}

\item{maxits}{Number of iterations to run}

\item{tol}{Vector of stopping tolerances, first value is absolute, second is relative tolerance.}

\item{quiet}{Logical controlling display of intermediate statistics.}

\item{alpha}{Step length.}
}
\value{
\code{ADMM_EN2} returns an object of \code{\link{class}} "\code{ADMM_EN2}" including a list
with the following named components

\describe{
  \item{\code{call}}{The matched call.}
  \item{\code{x}}{Found solution.}
  \item{\code{y}}{Dual solution.}
  \item{\code{z}}{Slack variables.}
  \item{\code{k}}{Number of iterations used.}
}
}
\description{
Applies Alternating Direction Method of Multipliers to the l1-regularized quadratic program
\deqn{f(\mathbf{x}) + g(\mathbf{x}) = \frac{1}{2}\mathbf{x}^TA\mathbf{x} - d^T\mathbf{x} + \lambda |\mathbf{x}|_1}{f(x) + g(x) = 0.5*x^T*A*x - d^T*x + lambda*|x|_l1}
}
\details{
This function is used by other functions and should only be called explicitly for
debugging purposes.
}
\seealso{
Used by: \code{\link{SDAD}} and the \code{SDADcv} cross-validation version.
}
\keyword{internal}
