% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sedbreaks.R
\name{sedbreaks}
\alias{sedbreaks}
\title{Sedentary Breaks}
\usage{
sedbreaks(counts, weartime = NULL, thresh = 100, flags = FALSE)
}
\arguments{
\item{counts}{Integer vector with accelerometer count values.}

\item{weartime}{Integer vector with 1's for wear time minutes and 0's for 
non-wear time minutes.}

\item{thresh}{Integer value specifying minimum count value to consider a 
break from sedentary time.}

\item{flags}{Logical value for whether to return a vector of 1's and 0's 
flagging the sedentary breaks (as opposed to the total number of sedentary 
breaks).}
}
\value{
Integer value or vector depending on \code{flags}.
}
\description{
Identifies sedentary breaks in accelerometer count data.
}
\examples{
# Load accelerometer data for first 5 participants in NHANES 2003-2004
data(unidata)

# Get data from ID number 21005
id.part1 <- unidata[unidata[, "seqn"] == 21005, "seqn"]
counts.part1 <- unidata[unidata[, "seqn"] == 21005, "paxinten"]

# Identify periods of valid wear time
wear.part1 <- weartime(counts = counts.part1)

# Count number of sedentary breaks (over full week)
n.sedbreaks <- sedbreaks(counts = counts.part1, weartime = wear.part1)

# Flag sedentary breaks
sedbreaks.flagged <- sedbreaks(counts = counts.part1, weartime = wear.part1, 
                               flags = TRUE)


}
