% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_fig_res_by_day.R
\name{create_fig_res_by_day}
\alias{create_fig_res_by_day}
\title{Create a figure with metrics shown for each day}
\usage{
create_fig_res_by_day(
  data,
  minimum_wear_time_for_analysis,
  start_day_analysis,
  end_day_analysis,
  language = c("en", "fr")
)
}
\arguments{
\item{data}{A dataframe with results obtained using the \code{\link{prepare_dataset}},  \code{\link{mark_wear_time}}, \code{\link{mark_intensity}}, and then the \code{\link{recap_by_day}} functions.}

\item{minimum_wear_time_for_analysis}{A numeric value to indicate the minimum number of hours of wear time that was considered to valid a day.}

\item{start_day_analysis}{A character value to indicate the start of the period that was considered to valid a day based on wear time.}

\item{end_day_analysis}{A character value to indicate the end of the period that was considered to valid a day based on wear time.}

\item{language}{A character value for setting the language with which the figure should be created: \code{en} for english; \code{fr} for french.}
}
\value{
A ggplot object
}
\description{
The function generates a figure with several common metrics shown for each day of the physical behavior measurement.
}
\examples{
file <- system.file("extdata", "acc.agd", package = "activAnalyzer")
mydata <- prepare_dataset(data = file)
mydata_with_wear_marks <- mark_wear_time(
    dataset = mydata, 
    TS = "TimeStamp", 
    cts  = "vm", 
    frame = 90, 
    allowanceFrame = 2, 
    streamFrame = 30
    )
mydata_with_intensity_marks <- mark_intensity(
    data = mydata_with_wear_marks, 
    col_axis = "vm", 
    equation = "Sasaki et al. (2011) [Adults]",
    sed_cutpoint = 200, 
    mpa_cutpoint = 2690, 
    vpa_cutpoint = 6167, 
    age = 32,
    weight = 67,
    sex = "male",
    )
summary_by_day <- recap_by_day(
    data = mydata_with_intensity_marks, 
    age = 32, 
    weight = 67, 
    sex = "male",
    valid_wear_time_start = "07:00:00",
    valid_wear_time_end = "22:00:00"
    )
create_fig_res_by_day(summary_by_day, 
    minimum_wear_time_for_analysis = 10, 
    start_day_analysis = "00:00:00", 
    end_day_analysis = "23:59:00", 
    language = "en")

}
