% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_bmr.R
\name{compute_bmr}
\alias{compute_bmr}
\title{Compute Basal Metabolic Rate (BMR)}
\usage{
compute_bmr(
  age = 40,
  sex = c("male", "female", "intersex", "undefined", "prefer not to say"),
  weight = 70
)
}
\arguments{
\item{age}{A numeric value in yr.}

\item{sex}{A character value.}

\item{weight}{A numeric value in kg.}
}
\value{
A numeric value.
}
\description{
This function computes Basal Metabolic Rate in kcal/d using a Henry et al.
(2005; doi: 10.1079/PHN2005801) equation. This function is wrapped within
the \code{\link{mark_intensity}} and \code{\link{recap_by_day}} functions.
}
\examples{
compute_bmr(age = 32, sex = "male", weight = 67)

}
