% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_fig_pal.R
\name{create_fig_pal}
\alias{create_fig_pal}
\title{Create a figure showing the mean daily Physical Activity Level (PAL)}
\usage{
create_fig_pal(score, language = c("en", "fr", "de"))
}
\arguments{
\item{score}{A numeric value for mean daily PAL.}

\item{language}{A character value for setting the language with which the figure should be created: \code{en} for english; \code{fr} for french.}
}
\value{
A ggplot object.
}
\description{
The function generates a figure showing the daily mean of PAL in correspondence with the FAO
(2004; http://www.fao.org/3/y5686e/y5686e07.htm#bm07.3) categories.
}
\examples{
create_fig_pal(score = 1.8)

}
