% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepArchetypesRawData_robust.R
\name{stepArchetypesRawData_robust}
\alias{stepArchetypesRawData_robust}
\title{Archetype algorithm to raw data with the robust Frobenius norm}
\usage{
stepArchetypesRawData_robust(data, numArch, numRep = 3, 
                             verbose = TRUE, saveHistory = FALSE, prob)
}
\arguments{
\item{data}{Data to obtain archetypes.}

\item{numArch}{Number of archetypes to compute, from 1 to \code{numArch}.}

\item{numRep}{For each \code{numArch}, run the archetype algorithm \code{numRep} times.}

\item{verbose}{If TRUE, the progress during execution is shown.}

\item{saveHistory}{Save execution steps.}

\item{prob}{Probability with values in [0,1].}
}
\value{
A list with the archetypes.
}
\description{
This is a slight modification of \code{\link[Anthropometry]{stepArchetypesRawData}}
to use the archetype algorithm with the robust Frobenius norm.
}
\examples{
data(mtcars)
data <- as.matrix(mtcars)

numArch <- 5 
numRep <- 2

lass <- stepArchetypesRawData_robust(data = data, numArch = 1:numArch, 
                                     numRep = numRep, verbose = FALSE,
                                     saveHistory = FALSE, prob = 0.8)
str(lass)   
length(lass[[1]])
class(lass[[1]])                                       
                 
}
\seealso{
\code{\link{stepArchetypesRawData_norm_frob}}
}
\author{
Guillermo Vinue
}
