% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/archetypoids_norm_frob.R
\name{archetypoids_norm_frob}
\alias{archetypoids_norm_frob}
\title{Archetypoid algorithm with the Frobenius norm}
\usage{
archetypoids_norm_frob(numArchoid, data, huge = 200, ArchObj)
}
\arguments{
\item{numArchoid}{Number of archetypoids.}

\item{data}{Data matrix. Each row corresponds to an observation and each column 
corresponds to a variable. All variables are numeric.}

\item{huge}{Penalization added to solve the convex least squares problems.}

\item{ArchObj}{The list object returned by the 
\code{\link{stepArchetypesRawData_norm_frob}} function.}
}
\value{
A list with the following elements:
\itemize{
\item cases: Final vector of archetypoids.
\item rss: Residual sum of squares corresponding to the final vector of archetypoids.
\item archet_ini: Vector of initial archetypoids.
\item alphas: Alpha coefficients for the final vector of archetypoids.
\item resid: Matrix with the residuals.
}
}
\description{
This function is the same as \code{\link[Anthropometry]{archetypoids}} but the 2-norm 
is replaced by the Frobenius norm. Thus, the comparison with the robust archetypoids
can be directly made.
}
\examples{
data(mtcars)
data <- mtcars

k <- 3
numRep <- 2
huge <- 200

lass <- stepArchetypesRawData_norm_frob(data = data, numArch = k, 
                                        numRep = numRep, verbose = FALSE)

res <- archetypoids_norm_frob(k, data, huge, ArchObj = lass)
str(res)  
res$cases
res$rss                                                           

}
\references{
Eugster, M.J.A. and Leisch, F., From Spider-Man to Hero - Archetypal Analysis in 
R, 2009. \emph{Journal of Statistical Software} \bold{30(8)}, 1-23,
\url{https://doi.org/10.18637/jss.v030.i08}

Moliner, J. and Epifanio, I., Robust multivariate and functional archetypal analysis 
with application to financial time series analysis, 2018, submitted,
\url{https://arxiv.org/abs/1810.00919} 

Vinue, G., Epifanio, I., and Alemany, S., Archetypoids: a new approach to 
define representative archetypal data, 2015.
\emph{Computational Statistics and Data Analysis} \bold{87}, 102-115,
\url{https://doi.org/10.1016/j.csda.2015.01.018}

Vinue, G., Anthropometry: An R Package for Analysis of Anthropometric Data, 2017.
\emph{Journal of Statistical Software} \bold{77(6)}, 1-39,
\url{https://doi.org/10.18637/jss.v077.i06}
}
\seealso{
\code{\link[Anthropometry]{archetypoids}}
}
\author{
Irene Epifanio
}
