% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepArchetypesRawData_funct.R
\name{stepArchetypesRawData_funct}
\alias{stepArchetypesRawData_funct}
\title{Archetype algorithm to raw data with the functional Frobenius norm}
\usage{
stepArchetypesRawData_funct(data, numArch, numRep = 3, 
                            verbose = TRUE, saveHistory = FALSE, PM)
}
\arguments{
\item{data}{Data to obtain archetypes.}

\item{numArch}{Number of archetypes to compute, from 1 to \code{numArch}.}

\item{numRep}{For each \code{numArch}, run the archetype algorithm \code{numRep} times.}

\item{verbose}{If TRUE, the progress during execution is shown.}

\item{saveHistory}{Save execution steps.}

\item{PM}{Penalty matrix obtained with \code{\link[fda]{eval.penalty}}.}
}
\value{
A list with the archetypes.
}
\description{
This is a slight modification of \code{\link[Anthropometry]{stepArchetypesRawData}}
to use the functional archetype algorithm with the Frobenius norm.
}
\examples{
\dontrun{
library(fda)
?growth
str(growth)
hgtm <- t(growth$hgtm)
# Create basis:
basis_fd <- create.bspline.basis(c(1,ncol(hgtm)), 10)
PM <- eval.penalty(basis_fd)
# Make fd object:
temp_points <- 1:ncol(hgtm)
temp_fd <- Data2fd(argvals = temp_points, y = growth$hgtm, basisobj = basis_fd)
data_archs <- t(temp_fd$coefs)

lass <- stepArchetypesRawData_funct(data = data_archs, numArch = 3, 
                                    numRep = 5, verbose = FALSE, 
                                    saveHistory = FALSE, PM)
str(lass)   
length(lass[[1]])
class(lass[[1]])  
class(lass[[1]][[5]])                                 
}                                         

}
\references{
Cutler, A. and Breiman, L., Archetypal Analysis. \emph{Technometrics}, 1994,
\bold{36(4)}, 338-347, \url{https://doi.org/10.2307/1269949}

Epifanio, I., Functional archetype and archetypoid analysis, 2016. 
\emph{Computational Statistics and Data Analysis} \bold{104}, 24-34, 
\url{https://doi.org/10.1016/j.csda.2016.06.007}

Eugster, M.J.A. and Leisch, F., From Spider-Man to Hero - Archetypal Analysis in 
R, 2009. \emph{Journal of Statistical Software} \bold{30(8)}, 1-23,
\url{https://doi.org/10.18637/jss.v030.i08}
}
\author{
Irene Epifanio
}
