% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adea_loads.R
\name{adea_loads}
\alias{adea_loads}
\title{Compute the variables load ratios in DEA}
\usage{
adea_loads(
  input,
  output,
  ux,
  vy,
  load.orientation = c("inoutput", "input", "output")
)
}
\arguments{
\item{input}{A matrix or a data frame with the inputs of units to be evaluated, one row for each DMU and one column for each input.}

\item{output}{A matrix or a data frame with the outputs of units to be evaluated, one row for each DMU and one column for each output.}

\item{ux}{A matrix of weights for DMUs and input variables.}

\item{vy}{A matrix of weights for DMUs and output variables.}

\item{load.orientation}{It allows the selection of variables to be included in load analysis.
Its default value is "inoutput" which means that all input and all output variables will be included. Use "input" or "output" to include only input or output variables in load analysis.}
}
\value{
Loads ratios and load for input and output variables
}
\description{
For the given input, output and two sets of weights, the function computes the loads of each variable for such values.
}
\details{
In DEA analysis, even when the efficiency scores remain constants, there are a great level of freedom to select the sets of weights for input and output variables.

Not all those sets of weights attaches the same importance to the variables. 
This function allows to compute the load of each variable for the given weights in order to compare different sets of weights for the same efficiencies scores.
Also compute load.levels which are the minimum value of such loads.

Take into account that different sets of weights means different ways to model the efficiency.

This function does not solve any model, only if ux and vy are the optimal values for the adea model, this function provides the load-levels as described in the theoretical adea model.
}
\examples{
# Load data
data('cardealers4')
# Define input and output
input <- cardealers4[, 1:2]
output <- cardealers4[, 3:4]
# Make dea analysis
model <- dea(input, output, RTS = 'crs', DUAL = TRUE)
# Show results
model
# Compute loads for such weights
adea_loads(input, output, model$ux, model$vy)

}
