% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/import.R
\name{read.structure}
\alias{read.structure}
\title{Reading data from STRUCTURE}
\usage{
read.structure(file, n.ind = NULL, n.loc = NULL, onerowperind = NULL,
  col.lab = NULL, col.pop = NULL, col.others = NULL,
  row.marknames = NULL, NA.char = "-9", pop = NULL, sep = NULL,
  ask = TRUE, quiet = FALSE)
}
\arguments{
\item{file}{a character string giving the path to the file to convert, with
the appropriate extension.}

\item{n.ind}{an integer giving the number of genotypes (or 'individuals') in
the dataset}

\item{n.loc}{an integer giving the number of markers in the dataset}

\item{onerowperind}{a STRUCTURE coding option: are genotypes coded on a
single row (TRUE), or on two rows (FALSE, default)}

\item{col.lab}{an integer giving the index of the column containing labels
of genotypes. '0' if absent.}

\item{col.pop}{an integer giving the index of the column containing
population to which genotypes belong. '0' if absent.}

\item{col.others}{an vector of integers giving the indexes of the columns
containing other informations to be read. Will be available in @other of the
created object.}

\item{row.marknames}{an integer giving the index of the row containing the
names of the markers. '0' if absent.}

\item{NA.char}{the character string coding missing data. "-9" by default.
Note that in any case, series of zero (like "000") are interpreted as NA
too.}

\item{pop}{an optional factor giving the population of each individual.}

\item{sep}{a character string used as separator between alleles.}

\item{ask}{a logical specifying if the function should ask for optional
informations about the dataset (TRUE, default), or try to be as quiet as
possible (FALSE).}

\item{quiet}{logical stating whether a conversion message must be printed
(TRUE,default) or not (FALSE).}
}
\value{
an object of the class \code{genind}
}
\description{
The function \code{read.structure} reads STRUCTURE data files (.str ou
.stru) and convert them into a \linkS4class{genind} object. By default, this
function is interactive and asks a few questions about data content. This
can be disabled (for optional questions) by turning the 'ask' argument to
FALSE. However, one has to know the number of genotypes, of markers and if
genotypes are coded on a single or on two rows before importing data.
}
\details{
Note: \code{read.structure} is meant for DIPLOID DATA ONLY. Haploid data
with the STRUCTURE format can easily be read into R using \code{read.table}
or \code{read.csv} and then converted using \code{\link{df2genind}}.
}
\examples{
obj <- read.structure(system.file("files/nancycats.str",package="adegenet"),
  onerowperind=FALSE, n.ind=237, n.loc=9, col.lab=1, col.pop=2, ask=FALSE)

obj
}
\author{
Thibaut Jombart \email{t.jombart@imperial.ac.uk}
}
\references{
Pritchard, J.; Stephens, M. & Donnelly, P. (2000) Inference of
population structure using multilocus genotype data. \emph{Genetics},
\bold{155}: 945-959
}
\seealso{
\code{\link{import2genind}}, \code{\link{df2genind}},
\code{\link{read.fstat}}, \code{\link{read.genetix}},
\code{\link{read.genepop}}
}
\keyword{manip}

