% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/device_info.R
\name{device_type}
\alias{device_type}
\alias{device_type.adf_device}
\alias{device_capacity}
\alias{device_capacity.adf_device}
\alias{volume_capacity}
\alias{volume_capacity.adf_device}
\alias{volume_name}
\alias{volume_name<-}
\alias{volume_name.adf_device}
\alias{volume_name<-.adf_device}
\alias{n_volumes}
\alias{n_volumes.adf_device}
\alias{bytes_free}
\alias{bytes_free.adf_device}
\alias{is_bootable}
\alias{is_bootable.adf_device}
\alias{is_fast_file_system}
\alias{is_fast_file_system.adf_device}
\alias{is_international}
\alias{is_international.adf_device}
\alias{is_dircache}
\alias{is_dircache.adf_device}
\alias{is_write_protected}
\alias{is_write_protected.adf_device}
\title{Obtain information about an \code{adf_device} connection}
\usage{
device_type(dev, ...)

\method{device_type}{adf_device}(dev, ...)

device_capacity(dev, ...)

\method{device_capacity}{adf_device}(dev, ...)

volume_capacity(dev, ...)

\method{volume_capacity}{adf_device}(dev, vol = 0L, ...)

volume_name(dev, ...)

volume_name(dev, ...) <- value

\method{volume_name}{adf_device}(dev, vol = 0L, ...)

\method{volume_name}{adf_device}(dev, vol = 0L, ...) <- value

n_volumes(dev, ...)

\method{n_volumes}{adf_device}(dev, ...)

bytes_free(dev, ...)

\method{bytes_free}{adf_device}(dev, vol = 0L, ...)

is_bootable(dev, ...)

\method{is_bootable}{adf_device}(dev, vol = 0L, ...)

is_fast_file_system(dev, ...)

\method{is_fast_file_system}{adf_device}(dev, vol = 0L, ...)

is_international(dev, ...)

\method{is_international}{adf_device}(dev, vol = 0L, ...)

is_dircache(dev, ...)

\method{is_dircache}{adf_device}(dev, vol = 0L, ...)

is_write_protected(dev, ...)

\method{is_write_protected}{adf_device}(dev, ...)
}
\arguments{
\item{dev}{The virtual adf device for which information needs to be obtained.
It should be of class \code{adf_device} which can be created with \code{\link[=create_adf_device]{create_adf_device()}}
or \code{\link[=connect_adf]{connect_adf()}}.}

\item{...}{Ignored}

\item{vol}{Volume index number on the device starting at \code{0}. Default is \code{0}.
Note that floppy disks can only have 1 volume installed.}

\item{value}{Replacement value. In case of \code{volume_name()} it can be used to
assign a new name to the volume.}
}
\value{
Returns the requested information, or an updated copy of \code{dev} in case
of an assign operation (\verb{<-}).
}
\description{
A collection of functions to retrieve information about the virtual device, or
any volume (file system) available on the device. See examples for usage and
results.
}
\examples{
## Open virtual device to demonstrate methods
my_device <- demo_adf(write_protected = FALSE)

device_type(my_device)

device_capacity(my_device) # in bytes

volume_capacity(my_device) # in bytes

n_volumes(my_device) # number of volumes available on device

volume_name(my_device) # name of the volume

volume_name(my_device) <- "new_name" # rename the volume

bytes_free(my_device) # bytes available for writing

is_bootable(my_device) # tests if device is potentially bootable

is_fast_file_system(my_device) # tests if volume uses FFS

is_international(my_device) # tests if file system uses intl mode

is_dircache(my_device) # tests if file system uses dir caching

is_write_protected(my_device) # tests if device is protected against writing

close(my_device)
}
\author{
Pepijn de Vries
}
