% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSim.R
\name{plotSim}
\alias{plotSim}
\title{Plot (dis)similarity matrix}
\usage{
plotSim(
  mat,
  type = c("similarity", "dissimilarity"),
  clustering = NULL,
  dendro = NULL,
  k = NULL,
  log = TRUE,
  legendName = "intensity",
  main = NULL,
  priorCount = 0.5,
  stats = c("R.squared", "D.prime"),
  h = NULL,
  axis = FALSE,
  naxis = min(10, nrow(mat)),
  axistext = NULL,
  xlab = "objects",
  cluster_col = "darkred",
  mode = c("standard", "corrected", "total-disp", "within-disp", "average-disp")
)
}
\arguments{
\item{mat}{matrix to plot. It can be of class \code{'matrix'}, 
\code{'dgCMatrix'}, \code{'dsCMatrix'}, \code{'dist'}, \code{'HTCexp'},
\code{'snpMatrix'}.}

\item{type}{input matrix type. Can be either \code{"similarity"} or 
\code{"dissimilarity"} (kernels are supposed to be of type 
\code{"similarity"}).}

\item{clustering}{vector of clusters to display on the matrix (if not 
\code{NULL}). If \code{clustering} is provided, it must be a numeric vector
of length identical to the matrix size with clusters identified as 
consecutive integers 1, 2, 3, ...}

\item{dendro}{dendrogram provided as an \code{hclust} object, or as another
type of object that can be converted to \code{hclust} with \code{as.hclust}.}

\item{k}{number of clusters to display. Used only when \code{dendro} is not
\code{NULL} and \code{clustering} is \code{NULL}. The clustering is then 
deduced from the dendrogram by a standard cut.}

\item{log}{logical. Should the breaks be based on log-scaled values of the
matrix entries. Default to \code{TRUE}.}

\item{legendName}{character. Title of the legend. Default to 
\code{"intensity"}.}

\item{main}{character. Title of the plot. Default to \code{NULL} (no title).}

\item{priorCount}{numeric. Average count to be added to each entry of the
matrix to avoid taking log of zero. Used only if \code{log == TRUE} and 
default to 0.5.}

\item{stats}{input SNP correlation type. Used when \code{mat} is of type 
\code{SnpMatrix}.}

\item{h}{positive integer. Threshold distance for SNP correlation 
computation. Used when \code{mat} is of type \code{SnpMatrix}.}

\item{axis}{logical. Should x-axis be displayed on the plot? Default to 
\code{FALSE}.}

\item{naxis}{integer. If \code{axis == TRUE}, number of ticks to display on
the x-axis.}

\item{axistext}{character vector. If \code{axis == TRUE}, labels to display
of the x-axis (its length has to be equal to \code{naxis}).}

\item{xlab}{character. If \code{axis == TRUE}, x-axis title.}

\item{cluster_col}{colour for the cluster line if \code{clustering} is not
\code{NULL}.}

\item{mode}{type of dendrogram to plot (see \code{\link{plot.chac}}). Default
to \code{"standard"}.}
}
\description{
Heatmap of the (dis)similarity matrix
}
\details{
This function produces a heatmap for the used (dis)similarity matrix that 
can be used as a diagnostic plot to check the consistency between the 
obtained clustering and the original (dis)similarity
}
\examples{
\dontrun{
clustering <- rep(1:3, each = 50)
dist_data <- as.matrix(dist(iris[, 1:4]))
dendro_iris <- adjClust(dist_data, type = "dissimilarity")
plotSim(dist_data, type = "dissimilarity", dendro = dendro_iris, axis = TRUE)
plotSim(dist_data, type = "dissimilarity", dendro = dendro_iris,
        clustering = clustering)
plotSim(dist_data, type = "dissimilarity", dendro = dendro_iris, axis = TRUE,
        k = 3)
plotSim(dist_data, type = "dissimilarity", legendName = "IF", axis = TRUE, 
        clustering = clustering)
p <- plotSim(dist(iris[, 1:4]), type = "dissimilarity", log = FALSE, 
             clustering = clustering, cluster_col = "blue")
# custom palette
p + scale_fill_gradient(low = "yellow", high = "red")
# dsCMatrix
m <- Matrix(c(0, 0, 2, 0, 3, 0, 2, 0, 0), ncol = 3)
res <- adjClust(m)
plotSim(m, axis = TRUE)
plotSim(m, dendro = res)
# dgCMatrix
m <- as(m, "generalMatrix")
plotSim(m)
m <- as.dist(m)
if (require("HiTC", quietly = TRUE)) {
  load(system.file("extdata", "hic_imr90_40_XX.rda", package = "adjclust"))
  res <- hicClust(hic_imr90_40_XX, log = TRUE)
  plotSim(hic_imr90_40_XX, axis = TRUE)
}
if (requireNamespace("snpStats", quietly = TRUE)) {
  data(testdata, package = "snpStats")
  plotSim(Autosomes[1:200, 1:5], h = 3, stats = "R.squared", axis = TRUE,
          axistext = c("A", "B", "C", "D", "E"))
}
}
}
\seealso{
\code{\link{select}}, \code{\link{adjClust}}
}
