% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_integer_scalar}
\alias{assert_integer_scalar}
\title{Is an Argument an Integer Scalar?}
\usage{
assert_integer_scalar(arg, subset = "none", optional = FALSE)
}
\arguments{
\item{arg}{A function argument to be checked}

\item{subset}{A subset of integers that \code{arg} should be part of. Should be one
of \code{"none"} (the default), \code{"positive"}, \code{"non-negative"} or \code{"negative"}.}

\item{optional}{Is the checked parameter optional? If set to \code{FALSE} and \code{arg}
is \code{NULL} then an error is thrown}
}
\value{
The function throws an error if \code{arg} is not an integer belonging to the
specified \code{subset}. Otherwise, the input is returned invisibly.
}
\description{
Checks if an argument is an integer scalar
}
\examples{
example_fun <- function(num1, num2) {
  assert_integer_scalar(num1, subset = "positive")
  assert_integer_scalar(num2, subset = "negative")
}

example_fun(1, -9)

try(example_fun(1.5, -9))

try(example_fun(2, 0))

try(example_fun("2", 0))
}
\author{
Thomas Neitmann
}
\keyword{assertion}
