% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_function}
\alias{assert_function}
\title{Is Argument a Function?}
\usage{
assert_function(arg, params = NULL, optional = FALSE)
}
\arguments{
\item{arg}{A function argument to be checked}

\item{params}{A character vector of expected parameter names}

\item{optional}{Is the checked parameter optional?

If set to \code{FALSE} and \code{arg} is \code{NULL} then an error is thrown.}
}
\value{
The function throws an error
\itemize{
\item if the argument is not a function or
\item if the function does not provide all parameters as specified for the
\code{params} parameter.
}
}
\description{
Checks if the argument is a function and if all expected parameters are
provided by the function.
}
\examples{
example_fun <- function(fun) {
  assert_function(fun, params = c("x"))
}

example_fun(mean)

try(example_fun(1))

try(example_fun(sum))
}
\seealso{
Checks for valid input and returns warning or errors messages: 
\code{\link{assert_atomic_vector}()},
\code{\link{assert_character_scalar}()},
\code{\link{assert_character_vector}()},
\code{\link{assert_data_frame}()},
\code{\link{assert_date_vector}()},
\code{\link{assert_expr}()},
\code{\link{assert_filter_cond}()},
\code{\link{assert_function_param}()},
\code{\link{assert_has_variables}()},
\code{\link{assert_integer_scalar}()},
\code{\link{assert_list_element}()},
\code{\link{assert_list_of}()},
\code{\link{assert_logical_scalar}()},
\code{\link{assert_named_exprs}()},
\code{\link{assert_numeric_vector}()},
\code{\link{assert_one_to_one}()},
\code{\link{assert_order_vars}()},
\code{\link{assert_param_does_not_exist}()},
\code{\link{assert_s3_class}()},
\code{\link{assert_same_type}()},
\code{\link{assert_symbol}()},
\code{\link{assert_unit}()},
\code{\link{assert_vars}()},
\code{\link{assert_varval_list}()}
}
\author{
Stefan Bundfuss
}
\concept{assertion}
\keyword{assertion}
